# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.organization_user import OrganizationUser
from edgeimpulse_api.models.project import Project

class AdminApiOrganization(BaseModel):
    id: StrictInt = ...
    name: StrictStr = Field(..., description="EdgeImpulse Inc.")
    logo: Optional[StrictStr] = None
    header_img: Optional[StrictStr] = Field(None, alias="headerImg")
    show_header_img_mask: StrictBool = Field(..., alias="showHeaderImgMask")
    users: List[OrganizationUser] = ...
    is_developer_profile: StrictBool = Field(..., alias="isDeveloperProfile")
    whitelabel_id: Optional[StrictInt] = Field(..., alias="whitelabelId", description="Unique identifier of the white label this organization belongs to, if any.")
    projects: List[Project] = Field(..., description="Array with organizational projects")
    trial_id: Optional[StrictInt] = Field(..., alias="trialId", description="Unique identifier of the trial this organization belongs to, if any.")
    trial_expired_date: Optional[datetime] = Field(..., alias="trialExpiredDate", description="Date when the trial expired, if any. A expired trial has a grace period of 30 days before it's associated organization is deleted.")
    trial_upgraded_date: Optional[datetime] = Field(..., alias="trialUpgradedDate", description="Date when the trial was upgraded to a full enterprise account, if any.")
    created: datetime = Field(..., description="Date when the organization was created.")
    contract_start_date: Optional[datetime] = Field(None, alias="contractStartDate", description="Date when the current contract started, if any.")
    deleted_date: Optional[datetime] = Field(None, alias="deletedDate", description="The date in which the organization was deleted. If the organization is not deleted, this field is not set.")
    __properties = ["id", "name", "logo", "headerImg", "showHeaderImgMask", "users", "isDeveloperProfile", "whitelabelId", "projects", "trialId", "trialExpiredDate", "trialUpgradedDate", "created", "contractStartDate", "deletedDate"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AdminApiOrganization:
        """Create an instance of AdminApiOrganization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item in self.users:
                if _item:
                    _items.append(_item.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item in self.projects:
                if _item:
                    _items.append(_item.to_dict())
            _dict['projects'] = _items
        # set to None if whitelabel_id (nullable) is None
        if self.whitelabel_id is None:
            _dict['whitelabelId'] = None

        # set to None if trial_id (nullable) is None
        if self.trial_id is None:
            _dict['trialId'] = None

        # set to None if trial_expired_date (nullable) is None
        if self.trial_expired_date is None:
            _dict['trialExpiredDate'] = None

        # set to None if trial_upgraded_date (nullable) is None
        if self.trial_upgraded_date is None:
            _dict['trialUpgradedDate'] = None

        # set to None if contract_start_date (nullable) is None
        if self.contract_start_date is None:
            _dict['contractStartDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminApiOrganization:
        """Create an instance of AdminApiOrganization from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AdminApiOrganization.construct(**obj)

        _obj = AdminApiOrganization.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "logo": obj.get("logo"),
            "header_img": obj.get("headerImg"),
            "show_header_img_mask": obj.get("showHeaderImgMask"),
            "users": [OrganizationUser.from_dict(_item) for _item in obj.get("users")] if obj.get("users") is not None else None,
            "is_developer_profile": obj.get("isDeveloperProfile"),
            "whitelabel_id": obj.get("whitelabelId"),
            "projects": [Project.from_dict(_item) for _item in obj.get("projects")] if obj.get("projects") is not None else None,
            "trial_id": obj.get("trialId"),
            "trial_expired_date": obj.get("trialExpiredDate"),
            "trial_upgraded_date": obj.get("trialUpgradedDate"),
            "created": obj.get("created"),
            "contract_start_date": obj.get("contractStartDate"),
            "deleted_date": obj.get("deletedDate")
        })
        return _obj

