# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.add_organization_dsp_block_request import AddOrganizationDspBlockRequest
from edgeimpulse_api.models.add_organization_secret_request import AddOrganizationSecretRequest
from edgeimpulse_api.models.add_organization_transfer_learning_block_request import AddOrganizationTransferLearningBlockRequest
from edgeimpulse_api.models.add_organization_transformation_block_request import AddOrganizationTransformationBlockRequest
from edgeimpulse_api.models.entity_created_response import EntityCreatedResponse
from edgeimpulse_api.models.export_block_response import ExportBlockResponse
from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_organization_deploy_block_response import GetOrganizationDeployBlockResponse
from edgeimpulse_api.models.get_organization_dsp_block_response import GetOrganizationDspBlockResponse
from edgeimpulse_api.models.get_organization_transfer_learning_block_response import GetOrganizationTransferLearningBlockResponse
from edgeimpulse_api.models.get_organization_transformation_block_response import GetOrganizationTransformationBlockResponse
from edgeimpulse_api.models.get_public_organization_transformation_block_response import GetPublicOrganizationTransformationBlockResponse
from edgeimpulse_api.models.list_organization_deploy_blocks_response import ListOrganizationDeployBlocksResponse
from edgeimpulse_api.models.list_organization_dsp_blocks_response import ListOrganizationDspBlocksResponse
from edgeimpulse_api.models.list_organization_secrets_response import ListOrganizationSecretsResponse
from edgeimpulse_api.models.list_organization_transfer_learning_blocks_response import ListOrganizationTransferLearningBlocksResponse
from edgeimpulse_api.models.list_organization_transformation_blocks_response import ListOrganizationTransformationBlocksResponse
from edgeimpulse_api.models.list_public_organization_transformation_blocks_response import ListPublicOrganizationTransformationBlocksResponse
from edgeimpulse_api.models.update_organization_dsp_block_request import UpdateOrganizationDspBlockRequest
from edgeimpulse_api.models.update_organization_transfer_learning_block_request import UpdateOrganizationTransferLearningBlockRequest
from edgeimpulse_api.models.update_organization_transformation_block_request import UpdateOrganizationTransformationBlockRequest

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrganizationBlocksApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def add_organization_deploy_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], name : StrictStr, docker_container : StrictStr, description : StrictStr, cli_arguments : StrictStr, requests_cpu : Optional[float] = None, requests_memory : Optional[StrictInt] = None, limits_cpu : Optional[float] = None, limits_memory : Optional[StrictInt] = None, photo : Optional[StrictStr] = None, integrate_url : Optional[StrictStr] = None, privileged : Optional[StrictBool] = None, mount_learn_block : Optional[StrictBool] = None, supports_eon_compiler : Optional[StrictBool] = None, show_optimizations : Optional[StrictBool] = None, category : Optional[StrictStr] = None, **kwargs) -> EntityCreatedResponse:  # noqa: E501
        """Add deploy block

        Adds a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param name: (required)
        :type name: str
        :param docker_container: (required)
        :type docker_container: str
        :param description: (required)
        :type description: str
        :param cli_arguments: (required)
        :type cli_arguments: str
        :param requests_cpu:
        :type requests_cpu: float
        :param requests_memory:
        :type requests_memory: int
        :param limits_cpu:
        :type limits_cpu: float
        :param limits_memory:
        :type limits_memory: int
        :param photo:
        :type photo: str
        :param integrate_url:
        :type integrate_url: str
        :param privileged:
        :type privileged: bool
        :param mount_learn_block:
        :type mount_learn_block: bool
        :param supports_eon_compiler:
        :type supports_eon_compiler: bool
        :param show_optimizations:
        :type show_optimizations: bool
        :param category:
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EntityCreatedResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_deploy_block_with_http_info(organization_id, name, docker_container, description, cli_arguments, requests_cpu, requests_memory, limits_cpu, limits_memory, photo, integrate_url, privileged, mount_learn_block, supports_eon_compiler, show_optimizations, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_deploy_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], name : StrictStr, docker_container : StrictStr, description : StrictStr, cli_arguments : StrictStr, requests_cpu : Optional[float] = None, requests_memory : Optional[StrictInt] = None, limits_cpu : Optional[float] = None, limits_memory : Optional[StrictInt] = None, photo : Optional[StrictStr] = None, integrate_url : Optional[StrictStr] = None, privileged : Optional[StrictBool] = None, mount_learn_block : Optional[StrictBool] = None, supports_eon_compiler : Optional[StrictBool] = None, show_optimizations : Optional[StrictBool] = None, category : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """Add deploy block 

        Adds a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param name: (required)
        :type name: str
        :param docker_container: (required)
        :type docker_container: str
        :param description: (required)
        :type description: str
        :param cli_arguments: (required)
        :type cli_arguments: str
        :param requests_cpu:
        :type requests_cpu: float
        :param requests_memory:
        :type requests_memory: int
        :param limits_cpu:
        :type limits_cpu: float
        :param limits_memory:
        :type limits_memory: int
        :param photo:
        :type photo: str
        :param integrate_url:
        :type integrate_url: str
        :param privileged:
        :type privileged: bool
        :param mount_learn_block:
        :type mount_learn_block: bool
        :param supports_eon_compiler:
        :type supports_eon_compiler: bool
        :param show_optimizations:
        :type show_optimizations: bool
        :param category:
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EntityCreatedResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'name',
            'docker_container',
            'description',
            'cli_arguments',
            'requests_cpu',
            'requests_memory',
            'limits_cpu',
            'limits_memory',
            'photo',
            'integrate_url',
            'privileged',
            'mount_learn_block',
            'supports_eon_compiler',
            'show_optimizations',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_deploy_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['name']:
            _form_params.append(('name', _params['name']))
        if _params['docker_container']:
            _form_params.append(('dockerContainer', _params['docker_container']))
        if _params['description']:
            _form_params.append(('description', _params['description']))
        if _params['cli_arguments']:
            _form_params.append(('cliArguments', _params['cli_arguments']))
        if _params['requests_cpu']:
            _form_params.append(('requestsCpu', _params['requests_cpu']))
        if _params['requests_memory']:
            _form_params.append(('requestsMemory', _params['requests_memory']))
        if _params['limits_cpu']:
            _form_params.append(('limitsCpu', _params['limits_cpu']))
        if _params['limits_memory']:
            _form_params.append(('limitsMemory', _params['limits_memory']))
        if _params['photo']:
            _files['photo'] = _params['photo']
        if _params['integrate_url']:
            _form_params.append(('integrateUrl', _params['integrate_url']))
        if _params['privileged']:
            _form_params.append(('privileged', _params['privileged']))
        if _params['mount_learn_block']:
            _form_params.append(('mountLearnBlock', _params['mount_learn_block']))
        if _params['supports_eon_compiler']:
            _form_params.append(('supportsEonCompiler', _params['supports_eon_compiler']))
        if _params['show_optimizations']:
            _form_params.append(('showOptimizations', _params['show_optimizations']))
        if _params['category']:
            _form_params.append(('category', _params['category']))

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "EntityCreatedResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_dsp_block_request : AddOrganizationDspBlockRequest, **kwargs) -> EntityCreatedResponse:  # noqa: E501
        """Add dsp block

        Adds a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_dsp_block_request: (required)
        :type add_organization_dsp_block_request: AddOrganizationDspBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EntityCreatedResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_dsp_block_with_http_info(organization_id, add_organization_dsp_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_dsp_block_request : AddOrganizationDspBlockRequest, **kwargs):  # noqa: E501
        """Add dsp block 

        Adds a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_dsp_block_request: (required)
        :type add_organization_dsp_block_request: AddOrganizationDspBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EntityCreatedResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_dsp_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_dsp_block_request']:
            _body_params = _params['add_organization_dsp_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "EntityCreatedResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_secret(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_secret_request : AddOrganizationSecretRequest, **kwargs) -> EntityCreatedResponse:  # noqa: E501
        """Add secret

        Adds a secret.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_secret_request: (required)
        :type add_organization_secret_request: AddOrganizationSecretRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EntityCreatedResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_secret_with_http_info(organization_id, add_organization_secret_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_secret_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_secret_request : AddOrganizationSecretRequest, **kwargs):  # noqa: E501
        """Add secret 

        Adds a secret.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_secret_request: (required)
        :type add_organization_secret_request: AddOrganizationSecretRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EntityCreatedResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_secret_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_secret" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_secret_request']:
            _body_params = _params['add_organization_secret_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "EntityCreatedResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/secrets', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_transfer_learning_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_transfer_learning_block_request : AddOrganizationTransferLearningBlockRequest, **kwargs) -> EntityCreatedResponse:  # noqa: E501
        """Add transfer learning block

        Adds a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_transfer_learning_block_request: (required)
        :type add_organization_transfer_learning_block_request: AddOrganizationTransferLearningBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EntityCreatedResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_transfer_learning_block_with_http_info(organization_id, add_organization_transfer_learning_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_transfer_learning_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_transfer_learning_block_request : AddOrganizationTransferLearningBlockRequest, **kwargs):  # noqa: E501
        """Add transfer learning block 

        Adds a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_transfer_learning_block_request: (required)
        :type add_organization_transfer_learning_block_request: AddOrganizationTransferLearningBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EntityCreatedResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_transfer_learning_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_transfer_learning_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_transfer_learning_block_request']:
            _body_params = _params['add_organization_transfer_learning_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "EntityCreatedResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_transformation_block_request : AddOrganizationTransformationBlockRequest, **kwargs) -> EntityCreatedResponse:  # noqa: E501
        """Add transformation block

        Adds a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_transformation_block_request: (required)
        :type add_organization_transformation_block_request: AddOrganizationTransformationBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EntityCreatedResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_transformation_block_with_http_info(organization_id, add_organization_transformation_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_transformation_block_request : AddOrganizationTransformationBlockRequest, **kwargs):  # noqa: E501
        """Add transformation block 

        Adds a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_transformation_block_request: (required)
        :type add_organization_transformation_block_request: AddOrganizationTransformationBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EntityCreatedResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_transformation_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_transformation_block_request']:
            _body_params = _params['add_organization_transformation_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "EntityCreatedResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_deploy_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete deploy block

        Deletes a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_deploy_block_with_http_info(organization_id, deploy_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_deploy_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], **kwargs):  # noqa: E501
        """Delete deploy block 

        Deletes a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'deploy_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_deploy_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['deploy_id']:
            _path_params['deployId'] = _params['deploy_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy/{deployId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete dsp block

        Deletes a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_dsp_block_with_http_info(organization_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Delete dsp block 

        Deletes a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp/{dspId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_secret(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], secret_id : Annotated[StrictInt, Field(..., description="Secret ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete secret

        Deletes a secret

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param secret_id: Secret ID (required)
        :type secret_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_secret_with_http_info(organization_id, secret_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_secret_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], secret_id : Annotated[StrictInt, Field(..., description="Secret ID")], **kwargs):  # noqa: E501
        """Delete secret 

        Deletes a secret

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param secret_id: Secret ID (required)
        :type secret_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'secret_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_secret" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['secret_id']:
            _path_params['secretId'] = _params['secret_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/secrets/{secretId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_transfer_learning_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete transfer learning block

        Deletes a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_transfer_learning_block_with_http_info(organization_id, transfer_learning_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_transfer_learning_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], **kwargs):  # noqa: E501
        """Delete transfer learning block 

        Deletes a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transfer_learning_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_transfer_learning_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transfer_learning_id']:
            _path_params['transferLearningId'] = _params['transfer_learning_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning/{transferLearningId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete transformation block

        Deletes a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_transformation_block_with_http_info(organization_id, transformation_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs):  # noqa: E501
        """Delete transformation block 

        Deletes a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transformation_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transformation_id']:
            _path_params['transformationId'] = _params['transformation_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation/{transformationId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def export_organization_deploy_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], **kwargs) -> ExportBlockResponse:  # noqa: E501
        """Export deploy block

        Download the source code for this block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ExportBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._export_organization_deploy_block_with_http_info(organization_id, deploy_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _export_organization_deploy_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], **kwargs):  # noqa: E501
        """Export deploy block 

        Download the source code for this block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ExportBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'deploy_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_organization_deploy_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['deploy_id']:
            _path_params['deployId'] = _params['deploy_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ExportBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy/{deployId}/export', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def export_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> ExportBlockResponse:  # noqa: E501
        """Export dsp block

        Download the source code for this block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ExportBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._export_organization_dsp_block_with_http_info(organization_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _export_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Export dsp block 

        Download the source code for this block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ExportBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ExportBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp/{dspId}/export', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def export_organization_transfer_learning_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], **kwargs) -> ExportBlockResponse:  # noqa: E501
        """Export transfer learning block

        Download the source code for this block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ExportBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._export_organization_transfer_learning_block_with_http_info(organization_id, transfer_learning_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _export_organization_transfer_learning_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], **kwargs):  # noqa: E501
        """Export transfer learning block 

        Download the source code for this block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ExportBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transfer_learning_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_organization_transfer_learning_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transfer_learning_id']:
            _path_params['transferLearningId'] = _params['transfer_learning_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ExportBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning/{transferLearningId}/export', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def export_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs) -> ExportBlockResponse:  # noqa: E501
        """Export transformation block

        Download the source code for this block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ExportBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._export_organization_transformation_block_with_http_info(organization_id, transformation_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _export_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs):  # noqa: E501
        """Export transformation block 

        Download the source code for this block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ExportBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transformation_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transformation_id']:
            _path_params['transformationId'] = _params['transformation_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ExportBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation/{transformationId}/export', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_deploy_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], **kwargs) -> GetOrganizationDeployBlockResponse:  # noqa: E501
        """Get deploy block

        Gets a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationDeployBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_deploy_block_with_http_info(organization_id, deploy_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_deploy_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], **kwargs):  # noqa: E501
        """Get deploy block 

        Gets a deploy block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationDeployBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'deploy_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_deploy_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['deploy_id']:
            _path_params['deployId'] = _params['deploy_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationDeployBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy/{deployId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> GetOrganizationDspBlockResponse:  # noqa: E501
        """Get dsp block

        Gets a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationDspBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_dsp_block_with_http_info(organization_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Get dsp block 

        Gets a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationDspBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationDspBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp/{dspId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_transfer_learning_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], **kwargs) -> GetOrganizationTransferLearningBlockResponse:  # noqa: E501
        """Get transfer learning block

        Gets a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationTransferLearningBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_transfer_learning_block_with_http_info(organization_id, transfer_learning_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_transfer_learning_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], **kwargs):  # noqa: E501
        """Get transfer learning block 

        Gets a transfer learning block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationTransferLearningBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transfer_learning_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_transfer_learning_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transfer_learning_id']:
            _path_params['transferLearningId'] = _params['transfer_learning_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationTransferLearningBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning/{transferLearningId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs) -> GetOrganizationTransformationBlockResponse:  # noqa: E501
        """Get transformation block

        Get a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationTransformationBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_transformation_block_with_http_info(organization_id, transformation_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs):  # noqa: E501
        """Get transformation block 

        Get a transformation block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationTransformationBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transformation_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transformation_id']:
            _path_params['transformationId'] = _params['transformation_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationTransformationBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation/{transformationId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs) -> GetPublicOrganizationTransformationBlockResponse:  # noqa: E501
        """Get public transformation block

        Retrieve a transformation blocks published by other organizations, available for all organizations.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetPublicOrganizationTransformationBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_public_organization_transformation_block_with_http_info(organization_id, transformation_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_public_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], **kwargs):  # noqa: E501
        """Get public transformation block 

        Retrieve a transformation blocks published by other organizations, available for all organizations.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetPublicOrganizationTransformationBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transformation_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transformation_id']:
            _path_params['transformationId'] = _params['transformation_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetPublicOrganizationTransformationBlockResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation/public/{transformationId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_deploy_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationDeployBlocksResponse:  # noqa: E501
        """Get deploy blocks

        Retrieve all deploy blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationDeployBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_deploy_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_deploy_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get deploy blocks 

        Retrieve all deploy blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationDeployBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_deploy_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationDeployBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_dsp_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationDspBlocksResponse:  # noqa: E501
        """Get dsp blocks

        Retrieve all dsp blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationDspBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_dsp_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_dsp_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get dsp blocks 

        Retrieve all dsp blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationDspBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_dsp_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationDspBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_secrets(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationSecretsResponse:  # noqa: E501
        """Get secrets

        Retrieve all secrets.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationSecretsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_secrets_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_secrets_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get secrets 

        Retrieve all secrets.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationSecretsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_secrets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationSecretsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/secrets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_transfer_learning_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationTransferLearningBlocksResponse:  # noqa: E501
        """Get transfer learning blocks

        Retrieve all transfer learning blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationTransferLearningBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_transfer_learning_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_transfer_learning_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get transfer learning blocks 

        Retrieve all transfer learning blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationTransferLearningBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_transfer_learning_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationTransferLearningBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_organization_transformation_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListOrganizationTransformationBlocksResponse:  # noqa: E501
        """Get transformation blocks

        Retrieve all transformation blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrganizationTransformationBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_organization_transformation_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_organization_transformation_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get transformation blocks 

        Retrieve all transformation blocks.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrganizationTransformationBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_transformation_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListOrganizationTransformationBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_public_organization_transformation_blocks(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> ListPublicOrganizationTransformationBlocksResponse:  # noqa: E501
        """List public transformation blocks

        Retrieve all transformation blocks published by other organizations, available for all organizations.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListPublicOrganizationTransformationBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_public_organization_transformation_blocks_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_public_organization_transformation_blocks_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """List public transformation blocks 

        Retrieve all transformation blocks published by other organizations, available for all organizations.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListPublicOrganizationTransformationBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_public_organization_transformation_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListPublicOrganizationTransformationBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation/public', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def retry_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Retry connection to dsp block

        Retry launch a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._retry_organization_dsp_block_with_http_info(organization_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _retry_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Retry connection to dsp block 

        Retry launch a dsp block.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retry_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp/{dspId}/retry', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_deploy_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], name : Optional[StrictStr] = None, docker_container : Optional[StrictStr] = None, description : Optional[StrictStr] = None, cli_arguments : Optional[StrictStr] = None, requests_cpu : Optional[float] = None, requests_memory : Optional[StrictInt] = None, limits_cpu : Optional[float] = None, limits_memory : Optional[StrictInt] = None, photo : Optional[StrictStr] = None, integrate_url : Optional[StrictStr] = None, privileged : Optional[StrictBool] = None, mount_learn_block : Optional[StrictBool] = None, supports_eon_compiler : Optional[StrictBool] = None, show_optimizations : Optional[StrictBool] = None, category : Optional[StrictStr] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update deploy block

        Updates a deploy block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param name:
        :type name: str
        :param docker_container:
        :type docker_container: str
        :param description:
        :type description: str
        :param cli_arguments:
        :type cli_arguments: str
        :param requests_cpu:
        :type requests_cpu: float
        :param requests_memory:
        :type requests_memory: int
        :param limits_cpu:
        :type limits_cpu: float
        :param limits_memory:
        :type limits_memory: int
        :param photo:
        :type photo: str
        :param integrate_url:
        :type integrate_url: str
        :param privileged:
        :type privileged: bool
        :param mount_learn_block:
        :type mount_learn_block: bool
        :param supports_eon_compiler:
        :type supports_eon_compiler: bool
        :param show_optimizations:
        :type show_optimizations: bool
        :param category:
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_deploy_block_with_http_info(organization_id, deploy_id, name, docker_container, description, cli_arguments, requests_cpu, requests_memory, limits_cpu, limits_memory, photo, integrate_url, privileged, mount_learn_block, supports_eon_compiler, show_optimizations, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_deploy_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], deploy_id : Annotated[StrictInt, Field(..., description="Deploy block ID.")], name : Optional[StrictStr] = None, docker_container : Optional[StrictStr] = None, description : Optional[StrictStr] = None, cli_arguments : Optional[StrictStr] = None, requests_cpu : Optional[float] = None, requests_memory : Optional[StrictInt] = None, limits_cpu : Optional[float] = None, limits_memory : Optional[StrictInt] = None, photo : Optional[StrictStr] = None, integrate_url : Optional[StrictStr] = None, privileged : Optional[StrictBool] = None, mount_learn_block : Optional[StrictBool] = None, supports_eon_compiler : Optional[StrictBool] = None, show_optimizations : Optional[StrictBool] = None, category : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """Update deploy block 

        Updates a deploy block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param deploy_id: Deploy block ID. (required)
        :type deploy_id: int
        :param name:
        :type name: str
        :param docker_container:
        :type docker_container: str
        :param description:
        :type description: str
        :param cli_arguments:
        :type cli_arguments: str
        :param requests_cpu:
        :type requests_cpu: float
        :param requests_memory:
        :type requests_memory: int
        :param limits_cpu:
        :type limits_cpu: float
        :param limits_memory:
        :type limits_memory: int
        :param photo:
        :type photo: str
        :param integrate_url:
        :type integrate_url: str
        :param privileged:
        :type privileged: bool
        :param mount_learn_block:
        :type mount_learn_block: bool
        :param supports_eon_compiler:
        :type supports_eon_compiler: bool
        :param show_optimizations:
        :type show_optimizations: bool
        :param category:
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'deploy_id',
            'name',
            'docker_container',
            'description',
            'cli_arguments',
            'requests_cpu',
            'requests_memory',
            'limits_cpu',
            'limits_memory',
            'photo',
            'integrate_url',
            'privileged',
            'mount_learn_block',
            'supports_eon_compiler',
            'show_optimizations',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_deploy_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['deploy_id']:
            _path_params['deployId'] = _params['deploy_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['name']:
            _form_params.append(('name', _params['name']))
        if _params['docker_container']:
            _form_params.append(('dockerContainer', _params['docker_container']))
        if _params['description']:
            _form_params.append(('description', _params['description']))
        if _params['cli_arguments']:
            _form_params.append(('cliArguments', _params['cli_arguments']))
        if _params['requests_cpu']:
            _form_params.append(('requestsCpu', _params['requests_cpu']))
        if _params['requests_memory']:
            _form_params.append(('requestsMemory', _params['requests_memory']))
        if _params['limits_cpu']:
            _form_params.append(('limitsCpu', _params['limits_cpu']))
        if _params['limits_memory']:
            _form_params.append(('limitsMemory', _params['limits_memory']))
        if _params['photo']:
            _files['photo'] = _params['photo']
        if _params['integrate_url']:
            _form_params.append(('integrateUrl', _params['integrate_url']))
        if _params['privileged']:
            _form_params.append(('privileged', _params['privileged']))
        if _params['mount_learn_block']:
            _form_params.append(('mountLearnBlock', _params['mount_learn_block']))
        if _params['supports_eon_compiler']:
            _form_params.append(('supportsEonCompiler', _params['supports_eon_compiler']))
        if _params['show_optimizations']:
            _form_params.append(('showOptimizations', _params['show_optimizations']))
        if _params['category']:
            _form_params.append(('category', _params['category']))

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/deploy/{deployId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_dsp_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], update_organization_dsp_block_request : UpdateOrganizationDspBlockRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update dsp block

        Updates a dsp block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param update_organization_dsp_block_request: (required)
        :type update_organization_dsp_block_request: UpdateOrganizationDspBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_dsp_block_with_http_info(organization_id, dsp_id, update_organization_dsp_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_dsp_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], update_organization_dsp_block_request : UpdateOrganizationDspBlockRequest, **kwargs):  # noqa: E501
        """Update dsp block 

        Updates a dsp block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param update_organization_dsp_block_request: (required)
        :type update_organization_dsp_block_request: UpdateOrganizationDspBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'dsp_id',
            'update_organization_dsp_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_organization_dsp_block_request']:
            _body_params = _params['update_organization_dsp_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/dsp/{dspId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_transfer_learning_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], update_organization_transfer_learning_block_request : UpdateOrganizationTransferLearningBlockRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update transfer learning block

        Updates a transfer learning block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param update_organization_transfer_learning_block_request: (required)
        :type update_organization_transfer_learning_block_request: UpdateOrganizationTransferLearningBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_transfer_learning_block_with_http_info(organization_id, transfer_learning_id, update_organization_transfer_learning_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_transfer_learning_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transfer_learning_id : Annotated[StrictInt, Field(..., description="Transfer learning ID")], update_organization_transfer_learning_block_request : UpdateOrganizationTransferLearningBlockRequest, **kwargs):  # noqa: E501
        """Update transfer learning block 

        Updates a transfer learning block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transfer_learning_id: Transfer learning ID (required)
        :type transfer_learning_id: int
        :param update_organization_transfer_learning_block_request: (required)
        :type update_organization_transfer_learning_block_request: UpdateOrganizationTransferLearningBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transfer_learning_id',
            'update_organization_transfer_learning_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_transfer_learning_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transfer_learning_id']:
            _path_params['transferLearningId'] = _params['transfer_learning_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_organization_transfer_learning_block_request']:
            _body_params = _params['update_organization_transfer_learning_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transfer-learning/{transferLearningId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_transformation_block(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], update_organization_transformation_block_request : UpdateOrganizationTransformationBlockRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update transformation block

        Updates a transformation block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param update_organization_transformation_block_request: (required)
        :type update_organization_transformation_block_request: UpdateOrganizationTransformationBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_transformation_block_with_http_info(organization_id, transformation_id, update_organization_transformation_block_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_transformation_block_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], transformation_id : Annotated[StrictInt, Field(..., description="Transformation block ID.")], update_organization_transformation_block_request : UpdateOrganizationTransformationBlockRequest, **kwargs):  # noqa: E501
        """Update transformation block 

        Updates a transformation block. Only values in the body will be updated.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param transformation_id: Transformation block ID. (required)
        :type transformation_id: int
        :param update_organization_transformation_block_request: (required)
        :type update_organization_transformation_block_request: UpdateOrganizationTransformationBlockRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'transformation_id',
            'update_organization_transformation_block_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_transformation_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['transformation_id']:
            _path_params['transformationId'] = _params['transformation_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_organization_transformation_block_request']:
            _body_params = _params['update_organization_transformation_block_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/transformation/{transformationId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
