# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetPackerImageResult',
    'AwaitableGetPackerImageResult',
    'get_packer_image',
    'get_packer_image_output',
]

@pulumi.output_type
class GetPackerImageResult:
    """
    A collection of values returned by getPackerImage.
    """
    def __init__(__self__, bucket_name=None, build_id=None, cloud_image_id=None, cloud_provider=None, component_type=None, created_at=None, id=None, iteration_id=None, labels=None, organization_id=None, packer_run_uuid=None, project_id=None, region=None):
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if build_id and not isinstance(build_id, str):
            raise TypeError("Expected argument 'build_id' to be a str")
        pulumi.set(__self__, "build_id", build_id)
        if cloud_image_id and not isinstance(cloud_image_id, str):
            raise TypeError("Expected argument 'cloud_image_id' to be a str")
        pulumi.set(__self__, "cloud_image_id", cloud_image_id)
        if cloud_provider and not isinstance(cloud_provider, str):
            raise TypeError("Expected argument 'cloud_provider' to be a str")
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        if component_type and not isinstance(component_type, str):
            raise TypeError("Expected argument 'component_type' to be a str")
        pulumi.set(__self__, "component_type", component_type)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iteration_id and not isinstance(iteration_id, str):
            raise TypeError("Expected argument 'iteration_id' to be a str")
        pulumi.set(__self__, "iteration_id", iteration_id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if packer_run_uuid and not isinstance(packer_run_uuid, str):
            raise TypeError("Expected argument 'packer_run_uuid' to be a str")
        pulumi.set(__self__, "packer_run_uuid", packer_run_uuid)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="buildId")
    def build_id(self) -> str:
        return pulumi.get(self, "build_id")

    @property
    @pulumi.getter(name="cloudImageId")
    def cloud_image_id(self) -> str:
        return pulumi.get(self, "cloud_image_id")

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> str:
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> str:
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="iterationId")
    def iteration_id(self) -> str:
        return pulumi.get(self, "iteration_id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="packerRunUuid")
    def packer_run_uuid(self) -> str:
        return pulumi.get(self, "packer_run_uuid")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetPackerImageResult(GetPackerImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPackerImageResult(
            bucket_name=self.bucket_name,
            build_id=self.build_id,
            cloud_image_id=self.cloud_image_id,
            cloud_provider=self.cloud_provider,
            component_type=self.component_type,
            created_at=self.created_at,
            id=self.id,
            iteration_id=self.iteration_id,
            labels=self.labels,
            organization_id=self.organization_id,
            packer_run_uuid=self.packer_run_uuid,
            project_id=self.project_id,
            region=self.region)


def get_packer_image(bucket_name: Optional[str] = None,
                     cloud_provider: Optional[str] = None,
                     iteration_id: Optional[str] = None,
                     region: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPackerImageResult:
    """
    The Packer Image data source iteration gets the most recent iteration (or build) of an image, given an iteration id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcp as hcp

    hardened_source = hcp.get_packer_iteration(bucket_name="hardened-ubuntu-16-04",
        channel="production")
    foo = hcp.get_packer_image(bucket_name="hardened-ubuntu-16-04",
        cloud_provider="aws",
        iteration_id=hardened_source.ulid,
        region="us-east-1")
    pulumi.export("packer-registry-ubuntu", foo.cloud_image_id)
    ```

    > **Note:** This data source only returns the first found image's metadata filtered by the given schema values, from the returned list of images associated with the specified iteration. Therefore, if multiple images exist in the same region, it will only pick one of them. If that's the case, you may consider separating your builds into different buckets.
    """
    __args__ = dict()
    __args__['bucketName'] = bucket_name
    __args__['cloudProvider'] = cloud_provider
    __args__['iterationId'] = iteration_id
    __args__['region'] = region
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('hcp:index/getPackerImage:getPackerImage', __args__, opts=opts, typ=GetPackerImageResult).value

    return AwaitableGetPackerImageResult(
        bucket_name=__ret__.bucket_name,
        build_id=__ret__.build_id,
        cloud_image_id=__ret__.cloud_image_id,
        cloud_provider=__ret__.cloud_provider,
        component_type=__ret__.component_type,
        created_at=__ret__.created_at,
        id=__ret__.id,
        iteration_id=__ret__.iteration_id,
        labels=__ret__.labels,
        organization_id=__ret__.organization_id,
        packer_run_uuid=__ret__.packer_run_uuid,
        project_id=__ret__.project_id,
        region=__ret__.region)


@_utilities.lift_output_func(get_packer_image)
def get_packer_image_output(bucket_name: Optional[pulumi.Input[str]] = None,
                            cloud_provider: Optional[pulumi.Input[str]] = None,
                            iteration_id: Optional[pulumi.Input[str]] = None,
                            region: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPackerImageResult]:
    """
    The Packer Image data source iteration gets the most recent iteration (or build) of an image, given an iteration id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcp as hcp

    hardened_source = hcp.get_packer_iteration(bucket_name="hardened-ubuntu-16-04",
        channel="production")
    foo = hcp.get_packer_image(bucket_name="hardened-ubuntu-16-04",
        cloud_provider="aws",
        iteration_id=hardened_source.ulid,
        region="us-east-1")
    pulumi.export("packer-registry-ubuntu", foo.cloud_image_id)
    ```

    > **Note:** This data source only returns the first found image's metadata filtered by the given schema values, from the returned list of images associated with the specified iteration. Therefore, if multiple images exist in the same region, it will only pick one of them. If that's the case, you may consider separating your builds into different buckets.
    """
    ...
