#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include "registry.h"
#include "node.h"
#include "houdini.h"
#include "cmark.h"
#include "buffer.h"

int cmark_version() { return CMARK_VERSION; }

const char *cmark_version_string() { return CMARK_VERSION_STRING; }

char *cmark_markdown_to_html(const char *text, size_t len, int options) {
  cmark_node *doc;
  char *result;

  doc = cmark_parse_document(text, len, options);

  result = cmark_render_html(doc, options);
  cmark_node_free(doc);

  return result;
}

bool cmark_init(void) {
  cmark_discover_plugins();
  return true;
}

bool cmark_deinit(void) {
  cmark_release_plugins();
  return true;
}
