#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyprocessors_q_and_a']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['pymultirole-plugins>=0.5.0,<0.6.0',
 'torch==1.7.1',
 'protobuf',
 'sentencepiece',
 'transformers',
 'pandas']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-black',
          'flake8==3.9.2',
          'tox']}

entry_points = \
{'pyprocessors.plugins': ['q_and_a = '
                          'pyprocessors_q_and_a.q_and_a:QandAProcessor']}

setup(name='pyprocessors-q_and_a',
      version='0.5.6',
      description='Processor based on Huggingface transformers Q&A pipeline',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://github.com/oterrier/pyprocessors_q_and_a/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
