import { DeploymentResources } from './DeploymentResources';
import { ITransformer } from './ITransformer';
import { TransformConfig } from './util';
import { FeatureFlagProvider } from './FeatureFlags';
export interface GraphQLTransformOptions {
    transformers: ITransformer[];
    stackMapping?: StackMapping;
    transformConfig?: TransformConfig;
    featureFlags?: FeatureFlagProvider;
}
export declare type StackMapping = {
    [resourceId: string]: string;
};
export declare class GraphQLTransform {
    private transformers;
    private stackMappingOverrides;
    private transformConfig;
    private featureFlags;
    private seenTransformations;
    constructor(options: GraphQLTransformOptions);
    transform(schema: string): DeploymentResources;
    private updateContextForStackMappingOverrides;
    private createResourcesForSyncEnabledProject;
    private transformObject;
    private transformField;
    private transformArgument;
    private transformInterface;
    private transformScalar;
    private transformUnion;
    private transformEnum;
    private transformEnumValue;
    private transformInputObject;
    private transformInputField;
}
//# sourceMappingURL=GraphQLTransform.d.ts.map