export declare class ResourceConstants {
    static NONE: string;
    static DEFAULT_PAGE_LIMIT: number;
    static DEFAULT_SYNC_QUERY_PAGE_LIMIT: number;
    static DEFAULT_SEARCHABLE_PAGE_LIMIT: number;
    static readonly RESOURCES: {
        GraphQLAPILogicalID: string;
        GraphQLSchemaLogicalID: string;
        APIKeyLogicalID: string;
        AuthRolePolicy: string;
        UnauthRolePolicy: string;
        ElasticsearchAccessIAMRoleLogicalID: string;
        ElasticsearchDomainLogicalID: string;
        ElasticsearchStreamingLambdaIAMRoleLogicalID: string;
        ElasticsearchStreamingLambdaFunctionLogicalID: string;
        ElasticsearchDataSourceLogicalID: string;
        NoneDataSource: string;
        AuthCognitoUserPoolLogicalID: string;
        AuthCognitoUserPoolNativeClientLogicalID: string;
        AuthCognitoUserPoolJSClientLogicalID: string;
    };
    static PARAMETERS: {
        Env: string;
        S3DeploymentBucket: string;
        S3DeploymentRootKey: string;
        AppSyncApiName: string;
        AppSyncApiId: string;
        CreateAPIKey: string;
        AuthRoleName: string;
        UnauthRoleName: string;
        APIKeyExpirationEpoch: string;
        DynamoDBBillingMode: string;
        DynamoDBModelTableReadIOPS: string;
        DynamoDBModelTableWriteIOPS: string;
        DynamoDBEnablePointInTimeRecovery: string;
        DynamoDBEnableServerSideEncryption: string;
        ElasticsearchAccessIAMRoleName: string;
        ElasticsearchDebugStreamingLambda: string;
        ElasticsearchStreamingIAMRoleName: string;
        ElasticsearchStreamingFunctionName: string;
        ElasticsearchInstanceCount: string;
        ElasticsearchInstanceType: string;
        ElasticsearchEBSVolumeGB: string;
        ElasticsearchStreamingLambdaHandlerName: string;
        ElasticsearchStreamingLambdaRuntime: string;
        AuthCognitoUserPoolId: string;
    };
    static MAPPINGS: {};
    static CONDITIONS: {
        HasEnvironmentParameter: string;
        ShouldUsePayPerRequestBilling: string;
        ShouldUsePointInTimeRecovery: string;
        ShouldUseServerSideEncryption: string;
        ShouldCreateAPIKey: string;
        APIKeyExpirationEpochIsPositive: string;
    };
    static OUTPUTS: {
        GraphQLAPIEndpointOutput: string;
        GraphQLAPIApiKeyOutput: string;
        GraphQLAPIIdOutput: string;
        ElasticsearchStreamingLambdaIAMRoleArn: string;
        ElasticsearchAccessIAMRoleArn: string;
        ElasticsearchDomainArn: string;
        ElasticsearchDomainEndpoint: string;
        AuthCognitoUserPoolIdOutput: string;
        AuthCognitoUserPoolNativeClientOutput: string;
        AuthCognitoUserPoolJSClientOutput: string;
    };
    static METADATA: {};
    static readonly SNIPPETS: {
        AuthCondition: string;
        AuthMode: string;
        VersionedCondition: string;
        ModelObjectKey: string;
        DynamoDBNameOverrideMap: string;
        ModelQueryExpression: string;
        ModelQueryIndex: string;
        IsDynamicGroupAuthorizedVariable: string;
        IsLocalDynamicGroupAuthorizedVariable: string;
        IsStaticGroupAuthorizedVariable: string;
        IsOwnerAuthorizedVariable: string;
        IsLocalOwnerAuthorizedVariable: string;
        SyncResolverKey: string;
    };
}
//# sourceMappingURL=ResourceConstants.d.ts.map