"""
This module is an example of a barebones sample data provider for napari.

It implements the "sample data" specification.
see: https://napari.org/plugins/stable/npe2_manifest_specification.html

Replace code below according to your needs.
"""
from __future__ import annotations
import numpy

from .interpolation import interpolator_factory, SplineInterpolator

from functools import partial
from skimage import data

coin_data = {
    "data": [
        [
            [36.071978917437676, 35.0258895905841],
            [42.23824174570508, 64.62395116626762],
            [74.30280845269554, 52.291425509732804],
            [63.20353536181425, 22.076737651222558],
        ],
        [
            [41.004989180051595, 97.92177043891157],
            [52.72088855375965, 80.0396082369361],
            [73.68618216986881, 99.77164928739178],
            [60.12040394768054, 118.88706405502073],
            [42.85486802853181, 113.33742750958005],
        ],
        [
            [29.28908980634354, 160.81765128723902],
            [44.70474687701203, 133.06946856003572],
            [70.60305075573511, 148.48512563070426],
            [58.27052509920033, 176.23330835790756],
        ],
        [
            [31.755594937650514, 207.06462249924454],
            [42.85486802853181, 192.8822179942295],
            [69.36979819008162, 202.13161223663064],
            [60.12040394768054, 236.66268407492805],
            [32.98884750330397, 227.41328983252697],
        ],
        [
            [34.22210006895746, 269.960503347572],
            [52.72088855375965, 252.6949674284233],
            [71.8363033213886, 279.20989758997314],
            [57.65389881637357, 295.2421809434683],
            [39.15511033157138, 290.30917068085444],
        ],
        [
            [15.723311584155283, 337.17276817568666],
            [29.28908980634357, 309.42458544848336],
            [62.58690907898752, 311.2744642969636],
            [71.2196770385619, 342.7224047211273],
            [52.10426227093295, 364.3043246200632],
            [27.439210957863352, 358.13806179179585],
        ],
        [
            [104.51749631120582, 41.80877870167822],
            [121.78303223035452, 25.77649534818299],
            [145.8314572605974, 40.57552613602475],
            [135.3488104525428, 60.307567186480426],
            [116.8500219677406, 65.85720373192108],
        ],
        [
            [111.30038542229995, 105.93791211565919],
            [118.69990081622082, 83.73936593389654],
            [143.9815784121172, 96.68851787325808],
            [133.4989316040626, 123.20344803480789],
        ],
        [
            [111.30038542229995, 157.11789359027858],
            [123.01628479600801, 136.15259997416945],
            [145.8314572605974, 154.0347621761449],
            [128.56592134144864, 174.38342950942734],
        ],
        [
            [105.13412259403255, 201.5149859538039],
            [118.69990081622082, 183.63282375182843],
            [146.4480835434241, 208.297875064898],
            [116.23339568491387, 225.56341098404675],
        ],
        [
            [95.26810206880471, 276.1267661758394],
            [110.06713285664647, 247.76195716580935],
            [134.11555788688935, 251.46171486276984],
            [137.19868930102302, 287.2260392667207],
            [112.53363798795344, 295.8588072262951],
        ],
        [
            [106.36737515968606, 339.63927330699363],
            [120.54977966470109, 318.67397969088444],
            [141.5150732808102, 331.00650534741925],
            [130.41580018992892, 355.6715566604889],
        ],
        [
            [176.66277140193438, 42.425404984504965],
            [191.46180218977617, 26.39312163100972],
            [214.89360093719228, 42.42540498450495],
            [195.1615598867366, 62.77407231778737],
        ],
        [
            [174.81289255345416, 100.38827557021851],
            [190.8451759069494, 78.18972938845586],
            [218.5933586341527, 104.08803326717894],
            [189.61192334129595, 121.9701954691544],
        ],
        [
            [179.7459028160681, 161.43427757006577],
            [190.8451759069494, 135.5359736913427],
            [214.27697465436552, 146.0186204993973],
            [208.1107118260981, 170.0670455296401],
        ],
        [
            [171.11313485649373, 216.93064302447237],
            [189.61192334129595, 186.7159551659621],
            [214.89360093719228, 213.84751161033864],
            [191.46180218977617, 238.51256292340827],
        ],
        [
            [174.19626627062746, 273.04363476170573],
            [191.46180218977617, 252.6949674284233],
            [215.51022722001903, 279.2098975899731],
            [189.61192334129595, 297.09205979194854],
        ],
        [
            [156.9307303514787, 349.50529383222147],
            [172.96301370497395, 318.67397969088444],
            [211.19384324023184, 330.3898790645925],
            [213.04372208871206, 368.00408231702363],
            [179.7459028160681, 377.25347655942477],
            [162.48036689691935, 364.92095090288996],
        ],
        [
            [235.2422682704747, 47.358415247118884],
            [233.72106944786412, 37.38560308090564],
            [243.25840994722233, 26.39312163100972],
            [256.4751806506578, 18.532196655733742],
            [278.4061080683465, 21.460111368395786],
            [287.6555023107476, 47.358415247118856],
            [277.2789394646406, 68.59124130187982],
            [253.12443047245017, 76.33985053997564],
            [238.32539968460839, 59.69094090365367],
        ],
        [
            [248.19142020983622, 115.803932640887],
            [260.52394586637104, 91.1388813278174],
            [287.6555023107476, 112.10417494392657],
            [274.0897240885593, 136.1525999741694],
            [255.5909356037571, 131.83621599438226],
        ],
        [
            [236.47552083612817, 171.3002980952936],
            [246.341541361356, 148.4851256307042],
            [271.62321895725233, 144.78536793374377],
            [283.3391183309604, 165.1340352670262],
            [267.9234612602919, 200.28173338815037],
            [240.1752785330886, 192.8822179942295],
        ],
        [
            [240.79190481591536, 247.14533088298265],
            [264.22370356333147, 220.6304007214328],
            [285.80562346226736, 250.84508857994308],
            [256.20756188658385, 269.960503347572],
        ],
        [
            [242.02515738156882, 302.6416963373892],
            [262.37382471485125, 278.5932713071464],
            [290.12200744205455, 302.0250700545625],
            [259.2906933007175, 325.4568688019786],
        ],
        [
            [250.04129905831644, 363.68769833723644],
            [264.8403298461582, 335.93951561003314],
            [288.88875487640104, 359.987940640276],
            [269.7733401087721, 381.5698605392119],
        ],
    ],
    "method": {
        "name": "SplineInterpolator",
        "args": {"k": 3, "s": 0.0, "n": 10},
    },
}


def make_sample_data_coins():
    list_of_polygons = coin_data["data"]
    list_of_polygons = [numpy.array(p) for p in list_of_polygons]

    # the interpolator arguments
    name = coin_data["method"]["name"]
    kwargs = coin_data["method"]["args"]
    interpolator = interpolator_factory(name=name, **kwargs)

    layer_attributes = {"interpolator": interpolator, "name": "coin-poly"}
    return [
        (data.coins(), {"name": "coin-img"}, "image"),
        (list_of_polygons, layer_attributes, "splineit_ctrl"),
    ]


def make_sample_data(shape, radius=10.0):
    diam = radius * 2.0
    base = (
        numpy.array(
            [
                (1, 0),
                (0, 1),
                (-1, 0),
                (0, -1),
            ],
            dtype="float",
        )
        * radius
    )

    list_of_polygons = []
    for x in range(shape[0]):
        for y in range(shape[1]):
            p = base.copy() + [x * diam, y * diam]
            list_of_polygons.append(p)

    layer_attributes = {
        "interpolator": SplineInterpolator(),
        "name": "stresstest",
    }
    return [(list_of_polygons, layer_attributes, "splineit_ctrl")]


make_sample_data_s = partial(make_sample_data, shape=[5, 5])
make_sample_data_m = partial(make_sample_data, shape=[5, 5])
make_sample_data_l = partial(make_sample_data, shape=[10, 10])
make_sample_data_xl = partial(make_sample_data, shape=[20, 20])
make_sample_data_xxl = partial(make_sample_data, shape=[40, 40])
