# crc-pulp_maven-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 20250923.3
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_maven
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_maven
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import pulpcore.client.pulp_maven
from pulpcore.client.pulp_maven.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://env-ephemeral-uvahdp.apps.crc-eph.r9lp.p1.openshiftapps.com
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_maven.Configuration(
    host = "https://env-ephemeral-uvahdp.apps.crc-eph.r9lp.p1.openshiftapps.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_maven.Configuration(
    username = os.environ["USERNAME"],
    password = os.environ["PASSWORD"]
)

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_maven.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_maven.ApiMavenApi(api_client)
    name = 'name_example' # str | 
    path = 'path_example' # str | 
    pulp_domain = 'pulp_domain_example' # str | 
    x_task_diagnostics = ['x_task_diagnostics_example'] # List[str] | List of profilers to use on tasks. (optional)
    fields = ['fields_example'] # List[str] | A list of fields to include in the response. (optional)
    exclude_fields = ['exclude_fields_example'] # List[str] | A list of fields to exclude from the response. (optional)

    try:
        api_instance.get(name, path, pulp_domain, x_task_diagnostics=x_task_diagnostics, fields=fields, exclude_fields=exclude_fields)
    except ApiException as e:
        print("Exception when calling ApiMavenApi->get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://env-ephemeral-uvahdp.apps.crc-eph.r9lp.p1.openshiftapps.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiMavenApi* | [**get**](docs/ApiMavenApi.md#get) | **GET** /api/pulp/maven/{pulp_domain}/{name}/{path} | 
*ApiMavenApi* | [**put**](docs/ApiMavenApi.md#put) | **PUT** /api/pulp/maven/{pulp_domain}/{name}/{path} | 
*ContentArtifactApi* | [**create**](docs/ContentArtifactApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/content/maven/artifact/ | Create a maven artifact
*ContentArtifactApi* | [**list**](docs/ContentArtifactApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/content/maven/artifact/ | List maven artifacts
*ContentArtifactApi* | [**read**](docs/ContentArtifactApi.md#read) | **GET** {maven_maven_artifact_href} | Inspect a maven artifact
*ContentArtifactApi* | [**set_label**](docs/ContentArtifactApi.md#set_label) | **POST** {maven_maven_artifact_href}set_label/ | Set a label
*ContentArtifactApi* | [**unset_label**](docs/ContentArtifactApi.md#unset_label) | **POST** {maven_maven_artifact_href}unset_label/ | Unset a label
*DistributionsMavenApi* | [**create**](docs/DistributionsMavenApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/distributions/maven/maven/ | Create a maven distribution
*DistributionsMavenApi* | [**delete**](docs/DistributionsMavenApi.md#delete) | **DELETE** {maven_maven_distribution_href} | Delete a maven distribution
*DistributionsMavenApi* | [**list**](docs/DistributionsMavenApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/distributions/maven/maven/ | List maven distributions
*DistributionsMavenApi* | [**partial_update**](docs/DistributionsMavenApi.md#partial_update) | **PATCH** {maven_maven_distribution_href} | Update a maven distribution
*DistributionsMavenApi* | [**read**](docs/DistributionsMavenApi.md#read) | **GET** {maven_maven_distribution_href} | Inspect a maven distribution
*DistributionsMavenApi* | [**set_label**](docs/DistributionsMavenApi.md#set_label) | **POST** {maven_maven_distribution_href}set_label/ | Set a label
*DistributionsMavenApi* | [**unset_label**](docs/DistributionsMavenApi.md#unset_label) | **POST** {maven_maven_distribution_href}unset_label/ | Unset a label
*DistributionsMavenApi* | [**update**](docs/DistributionsMavenApi.md#update) | **PUT** {maven_maven_distribution_href} | Update a maven distribution
*RemotesMavenApi* | [**create**](docs/RemotesMavenApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/remotes/maven/maven/ | Create a maven remote
*RemotesMavenApi* | [**delete**](docs/RemotesMavenApi.md#delete) | **DELETE** {maven_maven_remote_href} | Delete a maven remote
*RemotesMavenApi* | [**list**](docs/RemotesMavenApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/remotes/maven/maven/ | List maven remotes
*RemotesMavenApi* | [**partial_update**](docs/RemotesMavenApi.md#partial_update) | **PATCH** {maven_maven_remote_href} | Update a maven remote
*RemotesMavenApi* | [**read**](docs/RemotesMavenApi.md#read) | **GET** {maven_maven_remote_href} | Inspect a maven remote
*RemotesMavenApi* | [**set_label**](docs/RemotesMavenApi.md#set_label) | **POST** {maven_maven_remote_href}set_label/ | Set a label
*RemotesMavenApi* | [**unset_label**](docs/RemotesMavenApi.md#unset_label) | **POST** {maven_maven_remote_href}unset_label/ | Unset a label
*RemotesMavenApi* | [**update**](docs/RemotesMavenApi.md#update) | **PUT** {maven_maven_remote_href} | Update a maven remote
*RepositoriesMavenApi* | [**add_cached_content**](docs/RepositoriesMavenApi.md#add_cached_content) | **POST** {maven_maven_repository_href}add_cached_content/ | Add cached content
*RepositoriesMavenApi* | [**create**](docs/RepositoriesMavenApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/repositories/maven/maven/ | Create a maven repository
*RepositoriesMavenApi* | [**delete**](docs/RepositoriesMavenApi.md#delete) | **DELETE** {maven_maven_repository_href} | Delete a maven repository
*RepositoriesMavenApi* | [**list**](docs/RepositoriesMavenApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/repositories/maven/maven/ | List maven repositorys
*RepositoriesMavenApi* | [**partial_update**](docs/RepositoriesMavenApi.md#partial_update) | **PATCH** {maven_maven_repository_href} | Update a maven repository
*RepositoriesMavenApi* | [**read**](docs/RepositoriesMavenApi.md#read) | **GET** {maven_maven_repository_href} | Inspect a maven repository
*RepositoriesMavenApi* | [**set_label**](docs/RepositoriesMavenApi.md#set_label) | **POST** {maven_maven_repository_href}set_label/ | Set a label
*RepositoriesMavenApi* | [**unset_label**](docs/RepositoriesMavenApi.md#unset_label) | **POST** {maven_maven_repository_href}unset_label/ | Unset a label
*RepositoriesMavenApi* | [**update**](docs/RepositoriesMavenApi.md#update) | **PUT** {maven_maven_repository_href} | Update a maven repository
*RepositoriesMavenVersionsApi* | [**delete**](docs/RepositoriesMavenVersionsApi.md#delete) | **DELETE** {maven_maven_repository_version_href} | Delete a repository version
*RepositoriesMavenVersionsApi* | [**list**](docs/RepositoriesMavenVersionsApi.md#list) | **GET** {maven_maven_repository_href}versions/ | List repository versions
*RepositoriesMavenVersionsApi* | [**read**](docs/RepositoriesMavenVersionsApi.md#read) | **GET** {maven_maven_repository_version_href} | Inspect a repository version
*RepositoriesMavenVersionsApi* | [**repair**](docs/RepositoriesMavenVersionsApi.md#repair) | **POST** {maven_maven_repository_version_href}repair/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [MavenMavenArtifact](docs/MavenMavenArtifact.md)
 - [MavenMavenArtifactResponse](docs/MavenMavenArtifactResponse.md)
 - [MavenMavenDistribution](docs/MavenMavenDistribution.md)
 - [MavenMavenDistributionResponse](docs/MavenMavenDistributionResponse.md)
 - [MavenMavenRemote](docs/MavenMavenRemote.md)
 - [MavenMavenRemoteResponse](docs/MavenMavenRemoteResponse.md)
 - [MavenMavenRemoteResponseHiddenFieldsInner](docs/MavenMavenRemoteResponseHiddenFieldsInner.md)
 - [MavenMavenRepository](docs/MavenMavenRepository.md)
 - [MavenMavenRepositoryResponse](docs/MavenMavenRepositoryResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedmavenMavenArtifactResponseList](docs/PaginatedmavenMavenArtifactResponseList.md)
 - [PaginatedmavenMavenDistributionResponseList](docs/PaginatedmavenMavenDistributionResponseList.md)
 - [PaginatedmavenMavenRemoteResponseList](docs/PaginatedmavenMavenRemoteResponseList.md)
 - [PaginatedmavenMavenRepositoryResponseList](docs/PaginatedmavenMavenRepositoryResponseList.md)
 - [PatchedmavenMavenDistribution](docs/PatchedmavenMavenDistribution.md)
 - [PatchedmavenMavenRemote](docs/PatchedmavenMavenRemote.md)
 - [PatchedmavenMavenRepository](docs/PatchedmavenMavenRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [Repair](docs/Repair.md)
 - [RepositoryAddCachedContent](docs/RepositoryAddCachedContent.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [SetLabel](docs/SetLabel.md)
 - [SetLabelResponse](docs/SetLabelResponse.md)
 - [UnsetLabel](docs/UnsetLabel.md)
 - [UnsetLabelResponse](docs/UnsetLabelResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication

<a id="cookieAuth"></a>
### cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 

<a id="json_header_remote_authentication"></a>
### json_header_remote_authentication

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **api.console**: grant_access_to_pulp


## Author

pulp-list@redhat.com


