# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:36:04 2022
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .aud import tAud
from .col import tCol
from .tran import tTran

class oAudSearch(mettle.io.ISerializable):

    def __init__(self,
                 tran: tTran = None,
                 aud: tAud = None,
                 col: tCol = None):
        """
        Constructor.

        :param tran: table -> table:Tran
        :param aud: table -> table:Aud
        :param col: table -> table:Col
        """
        self.tran = tTran()
        if tran:
            self.tran._copy_from(tran)
        self.aud = tAud()
        if aud:
            self.aud._copy_from(aud)
        self.col = tCol()
        if col:
            self.col._copy_from(col)

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.tran.clear()
        self.aud.clear()
        self.col.clear()

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'oAudSearch'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        self.tran._serialize(_w)
        self.aud._serialize(_w)
        self.col._serialize(_w)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.tran._deserialize(_r)
        self.aud._deserialize(_r)
        self.col._deserialize(_r)
        _r.read_end(_oname)

    def _copy_from(self, rec: "oAudSearch"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.tran._copy_from(rec.tran)
        self.aud._copy_from(rec.aud)
        self.col._copy_from(rec.col)

    def __repr__(self) -> str:
        return '<Aud [tran:%r, aud:%r, col:%r]>' % (
            self.tran, self.aud, self.col)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'oAudSearch.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = oAudSearch()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<oAudSearch.List[%d]>' % (len(self))

