# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:36:04 2022
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .aud_key import tAudKey

class tAud(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: int = 0,
                 tran_id: int = 0,
                 action: str = '',
                 tbl_id: str = '',
                 tbl_key: str = '',
                 par_tbl_id: str = '',
                 par_tbl_key: str = ''):
        """
        Constructor.

        :param id: int
        :param tran_id: int
        :param action: str
        :param tbl_id: str
        :param tbl_key: str
        :param par_tbl_id: str
        :param par_tbl_key: str
        """
        self.id = id
        self.tran_id = tran_id
        self.action = action
        self.tbl_id = tbl_id
        self.tbl_key = tbl_key
        self.par_tbl_id = par_tbl_id
        self.par_tbl_key = par_tbl_key

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = 0
        self.tran_id = 0
        self.action = ''
        self.tbl_id = ''
        self.tbl_key = ''
        self.par_tbl_id = ''
        self.par_tbl_key = ''

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tAud'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int64("id", self.id)
        _w.write_int64("tran_id", self.tran_id)
        _w.write_char("action", self.action)
        _w.write_string("tbl_id", self.tbl_id)
        _w.write_string("tbl_key", self.tbl_key)
        _w.write_string("par_tbl_id", self.par_tbl_id)
        _w.write_string("par_tbl_key", self.par_tbl_key)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_int64("id")
        self.tran_id = _r.read_int64("tran_id")
        self.action = _r.read_char("action")
        self.tbl_id = _r.read_string("tbl_id")
        self.tbl_key = _r.read_string("tbl_key")
        self.par_tbl_id = _r.read_string("par_tbl_id")
        self.par_tbl_key = _r.read_string("par_tbl_key")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tAud"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.tran_id = rec.tran_id
        self.action = rec.action
        self.tbl_id = rec.tbl_id
        self.tbl_key = rec.tbl_key
        self.par_tbl_id = rec.par_tbl_id
        self.par_tbl_key = rec.par_tbl_key

    def _write_pk(self, _key: "tAud"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tAud"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tAudKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tAudKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        if not for_ins:
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        if key_only:
            return dvc

        dvc.add_targ("tran_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("action", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("action", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("action", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("action", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['C','U','D']))
        dvc.add_targ("tbl_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("tbl_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 64))
        dvc.add_targ("tbl_key", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("tbl_key", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("par_tbl_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 64))
        dvc.add_targ("par_tbl_key", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tAud._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tAudKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tAudKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Action_Couplet(dict):
        key_create = "C"
        key_update = "U"
        key_delete = "D"

        value_create = "Create"
        value_update = "Update"
        value_delete = "Delete"

        def __init__(self):
            self[self.key_create] = self.value_create
            self[self.key_update] = self.value_update
            self[self.key_delete] = self.value_delete

        @staticmethod
        def get_value(key):
            if key == tAud.Action_Couplet.key_create:
                return tAud.Action_Couplet.value_create

            if key == tAud.Action_Couplet.key_update:
                return tAud.Action_Couplet.value_update

            if key == tAud.Action_Couplet.key_delete:
                return tAud.Action_Couplet.value_delete

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return x.id - y.id

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<Aud [id:%r, tran_id:%r, action:%.32s, tbl_id:%.32s, tbl_key:%.32s, par_tbl_id:%.32s, par_tbl_key:%.32s]>' % (
            self.id, self.tran_id, self.action, self.tbl_id, self.tbl_key, self.par_tbl_id, self.par_tbl_key)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tAud.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tAud()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tAud.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tAud._cache_davs(dvc, for_ins, key_only)

