# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:36:04 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.col import tCol

class dColInsert:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCol()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        aud_id: int,
                        name: str,
                        before: str,
                        after: str) -> "dColInsert":
        """
        Execute the query by setting all the inputs.

        :param aud_id: int
        :param name: str
        :param before: str
        :param after: str
        :return: Self for convenience.
        """
        self.irec.aud_id = aud_id
        self.irec.name = name
        self.irec.before = before
        self.irec.after = after

        return await self.exec()

    async def exec(self, irec: tCol = None) -> "dColInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("ColInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into audit.Col (
  aud_id,
  name,
  before,
  after
) values (
  :aud_id,
  :name,
  :before,
  :after
)""")

        self._dbstmnt.bind_in("aud_id", self.irec.aud_id, int, 8)
        self._dbstmnt.bind_in("name", self.irec.name, str, 64)
        self._dbstmnt.bind_in("before", self.irec.before, str, 128)
        self._dbstmnt.bind_in("after", self.irec.after, str, 128)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

