# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:36:04 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.cfg_key import tCfgKey
from bs_audit.db.tables.cfg import tCfg

class dCfgSelectOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCfgKey()
        self.orec     = tCfg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: str) -> "dCfgSelectOne":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :return: Self for convenience.
        """
        self.irec.id = id

        return await self.exec()

    async def exec(self, irec: tCfgKey = None) -> "dCfgSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("CfgSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  col_pk,
  col_ignr,
  par_id,
  par_col,
  last_chg
from
  audit.Cfg
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, str, 64)

        self._dbstmnt.bind_out("id", str, 64)
        self._dbstmnt.bind_out("col_pk", str, 1024)
        self._dbstmnt.bind_out("col_ignr", str, 4096)
        self._dbstmnt.bind_out("par_id", str, 64)
        self._dbstmnt.bind_out("par_col", str, 1024)
        self._dbstmnt.bind_out("last_chg", datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.col_pk = self._dbstmnt.result[1]
        self.orec.col_ignr = self._dbstmnt.result[2]
        self.orec.par_id = self._dbstmnt.result[3]
        self.orec.par_col = self._dbstmnt.result[4]
        self.orec.last_chg = self._dbstmnt.result[5]

        return True

    async def fetch_all(self, outList: tCfg.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

