# -*- coding: utf-8 -*-
#
# omas documentation build configuration file, created by
# sphinx-quickstart on Wed Oct 18 10:47:09 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

import os, sys, shutil, glob, re
sys.path.insert(0,os.path.split(os.path.split(os.path.split(os.path.abspath(__file__))[0])[0])[0])
import sphinx_bootstrap_theme
from omas import *
from matplotlib import pyplot
pyplot.switch_backend('agg')
import time
from collections import OrderedDict

sys.path.insert(0, os.path.abspath('../../'))

# ==============
# SCHEMA
# ==============
if os.path.exists('../source/schema/'):
    shutil.rmtree('../source/schema/')
os.makedirs('../source/schema/')
filename = os.path.abspath(os.sep.join([imas_json_dir, imas_versions[omas_rcparams['default_imas_version']], 'omas_doc.html']))
lines = open(filename).readlines()

f = None
for k, line in enumerate(lines):
    if '<!-- ' in line:
        sub = re.sub('_', ' ', re.sub('<!-- (.*) -->', r'\1', line).strip())
        lines[k] = '\n%s\n%s\n\n.. raw:: html\n\n' % (sub, '^' * len(sub) + '')
        if f is not None:
            f.close()
        f = open('../source/schema/schema_%s.rst' % sub, 'w')
    else:
        lines[k] = '   ' + lines[k]
    f.write(lines[k])

with open('../source/schema/whole_schema.rst', 'w') as f:
    f.write("""
complete schema
===============
""")
    f.write(''.join(lines))

with open('../source/schema.rst', 'w') as f:
    f.write("""
.. DO NOT EDIT THIS FILE BY HAND, EDIT conf.py FILE INSTEAD

IMAS & OMAS data schema
=======================

OMAS enforces compliance with the `IMAS data schema <https://git.iter.org/projects/IMAS/repos/data-dictionary/browse>`_.

For convenience we report here the documentation for IMAS data schema **version %s**.

The complete ITER IMAS data schema can be browsed here in a single page:

.. toctree::
    :maxdepth: 1
    :glob:

    schema/whole_schema

Alternatively, each of the %d individual Interface Data Structure (IDS) can be viewed here:

.. toctree::
    :glob:

    schema/schema*

Generalised Grid Description (GGD)
==================================
Scrape Off Layer data is stored in IMAS according to the
`Generalised Grid Description (GGD) <https://confluence.iter.org/pages/viewpage.action?pageId=178133297>`_
format (link requires ITER account).

""" % (omas_rcparams['default_imas_version'], len(glob.glob('../source/schema/schema_*.rst'))))
print('latest data structure version: '+omas_rcparams['default_imas_version'])

# ==============
# API
# ==============
import omas
tp_mapper=OrderedDict((('ABCMeta','OMAS data class'),('function','Functions'),('Misc','Misc'),('module','Modules')))
members={}
for item in omas.__all__:
    tp=tp_mapper.get(type(getattr(omas,item)).__name__,'Misc')
    if tp not in members:
        members[tp]=[]
    members[tp].append('omas.'+item)
if os.path.exists('../source/code'):
    shutil.rmtree('../source/code')
with open('../source/code.rst', 'w') as f:
    f.write("""
.. DO NOT EDIT THIS FILE BY HAND, EDIT conf.py FILE INSTEAD

============================
OMAS users API documentation
============================

Following are the classes/routines that are directly available to users within the `omas` library namespace 

""")
    for tp in tp_mapper.values():
        f.write("""
%s
%s

.. autosummary::
   :toctree: code


   %s
""" % (tp,'-'*len(tp),'   ' + '\n   '.join(sorted(members[tp]))))

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.mathjax',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'sphinx_gallery.gen_gallery',
    'sphinx.ext.autosummary']
autodoc_default_flags = ['members']
autosummary_generate = True

sphinx_gallery_conf = {
     # path to your examples scripts
     'examples_dirs': '../../omas/examples',
     # path where to save gallery generated examples
     'gallery_dirs': 'auto_examples',
     'download_all_examples': False,
     'min_reported_time':1000,
     'default_thumb_file': os.path.split(__file__)[0]+'/images/sphx_default_thumb.png'}

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The encoding of source files.
#
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'OMAS'
copyright = '2017-'+time.strftime("%Y")+' O. Meneghini and collaborators'
author = 'Orso Meneghini'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
# version = '0.0.1'
# The full version, including alpha/beta/rc tags.
# release = '0.0.1'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#
# today = ''
#
# Else, today_fmt is used as the format for a strftime call.
#
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = []

# The reST default role (used for this markup: `text`) to use for all
# documents.
#
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'bootstrap'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    # Navigation bar title. (Default: ``project`` value)
    'navbar_title': 'OMAS',

    # Tab name for entire site. (Default: "Site")
    'navbar_site_name': "Jump to",

    # A list of tuples containing pages or urls to link to.
    # Valid tuples should be in the following forms:
    #    (name, page)                 # a link to a page
    #    (name, "/aa/bb", 1)          # a link to an arbitrary relative url
    #    (name, "http://example.com", True) # arbitrary absolute url
    # Note the "1" or "True" value above as the third argument to indicate
    # an arbitrary url.
    'navbar_links': [  # ("Research", "publications"),
        ("Concept", "how"),
        ("Examples", "auto_examples/index"),
        ("Installation", "install"),
        ("ITER", "iter"),
        ("OMFIT", "omfit"),
        ("Data schema", "schema"),
        ("API", "code"),
        # ("Team", "contributors"),
        # ("Social", "social"),
        # ("Search", "search.html", 1),
    ],

    # Render the next and previous page links in navbar. (Default: true)
    'navbar_sidebarrel': False,

    # Render the current pages TOC in the navbar. (Default: true)
    'navbar_pagenav': True,

    # Tab name for the current pages TOC. (Default: "Page")
    'navbar_pagenav_name': "In this page",

    # Global TOC depth for "site" navbar tab. (Default: 1)
    # Switching to -1 shows all levels.
    'globaltoc_depth': -1,

    # Include hidden TOCs in Site navbar?
    #
    # Note: If this is "false", you cannot have mixed ``:hidden:`` and
    # non-hidden ``toctree`` directives in the same page, or else the build
    # will break.
    #
    # Values: "true" (default) or "false"
    'globaltoc_includehidden': "true",

    # HTML navbar class (Default: "navbar") to attach to <div> element.
    # For black navbar, do "navbar navbar-inverse"
    'navbar_class': "navbar",  # navbar-inverse",

    # Fix navigation bar to top of page?
    # Values: "true" (default) or "false"
    'navbar_fixed_top': "true",

    # Location of link to source.
    # Options are "nav" (default), "footer" or anything else to exclude.
    'source_link_position': "footer",

    # Bootswatch (http://bootswatch.com/) theme.
    #
    # Options are nothing (default) or the name of a valid theme
    # such as "amelia" or "cosmo".
    'bootswatch_theme': "simplex",

    # Choose Bootstrap version.
    # Values: "4" or "3" or "2"
    'bootstrap_version': "3",

    # Disable showing the sidebar. Defaults to 'false'
    'nosidebar': True,
}

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = sphinx_bootstrap_theme.get_html_theme_path()

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = 'OMAS'

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = 'images/OMAS_logo.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = 'images/favicon.png'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
#
# html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#
# html_additional_pages = {}

# If false, no module index is generated.
#
# html_domain_indices = True

# If false, no index is generated.
#
# html_use_index = True

# If true, the index is split into individual pages for each letter.
#
# html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = False

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
html_show_sphinx = False

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Language to be used for generating the HTML full-text search index.
# Sphinx supports the following languages:
#   'da', 'de', 'en', 'es', 'fi', 'fr', 'hu', 'it', 'ja'
#   'nl', 'no', 'pt', 'ro', 'ru', 'sv', 'tr', 'zh'
#
# html_search_language = 'en'

# A dictionary with options for the search language support, empty by default.
# 'ja' uses this config value.
# 'zh' user can custom change `jieba` dictionary path.
#
# html_search_options = {'type': 'default'}

# The name of a javascript file (relative to the configuration directory) that
# implements a search results scorer. If empty, the default will be used.
#
# html_search_scorer = 'scorer.js'

# Output file base name for HTML help builder.
htmlhelp_basename = 'omasdoc'

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'omas.tex', 'OMAS documentation',
     'Orso Meneghini', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#
# latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#
# latex_use_parts = False

# If true, show page references after internal links.
#
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
#
# latex_show_urls = False

# Documents to append as an appendix to all manuals.
#
# latex_appendices = []

# If false, no module index is generated.
#
# latex_domain_indices = True


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'OMAS', 'OMAS documentation',
     [author], 1)
]

# If true, show URL addresses after external links.
#
# man_show_urls = False


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'OMAS', 'OMAS documentation',
     author, 'OMAS', 'Ordered Multidimensional Array Structures',
     'Miscellaneous'),
]

# Documents to append as an appendix to all manuals.
#
# texinfo_appendices = []

# If false, no module index is generated.
#
# texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#
# texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
#
# texinfo_no_detailmenu = False
