from tfads_o_builder.feature_types._Base import _Base


class FeatureTypeCode(_Base):
    code_list = [
        "U",  # Misc Man-Made
        "UND",  # Unknown Feature Type
        99,
        101,
        103,
        104,
        105,
        106,
        107,
        110,
        111,
        112,
        115,
        116,
        120,
        121,
        122,
        123,
        130,
        136,
        137,
        145,
        146,
        150,
        151,
        152,
        153,
        154,
        155,
        156,
        160,
        161,
        162,
        163,
        164,
        165,
        166,
        170,
        172,
        173,
        180,
        181,
        182,
        183,
        184,
        185,
        186,
        187,
        188,
        189,
        190,
        221,
        222,
        223,
        224,
        260,
        261,
        262,
        263,
        264,
        265,
        266,
        267,
        270,
        271,
        272,
        273,
        274,
        275,
        276,
        280,
        281,
        282,
        290,
        301,
        302,
        303,
        304,
        305,
        321,
        322,
        323,
        324,
        331,
        332,
        334,
        335,
        340,
        350,
        401,
        402,
        403,
        434,
        435,
        437,
        438,
        450,
        501,
        504,
        505,
        511,
        512,
        520,
        521,
        530,
        531,
        532,
        533,
        535,
        536,
        537,
        538,
        540,
        541,
        542,
        543,
        544,
        561,
        601,
        602,
        603,
        604,
        605,
        606,
        607,
        610,
        620,
        621,
        622,
        630,
        631,
        632,
        640,
        641,
        650,
        651,
        652,
        653,
        654,
        680,
        681,
        682,
        683,
        684,
        702,
        703,
        704,
        705,
        710,
        711,
        714,
        715,
        716,
        717,
        718,
        720,
        721,
        755,
        761,
        765,
        785,
        801,
        802,
        803,
        804,
        805,
        806,
        807,
        811,
        812,
        820,
        821,
        822,
        824,
        830,
        831,
        861,
        865,
        900,
        901,
        902,
        903,
        925,
        926,
        954,
    ]

    def __init__(self):
        super().__init__()
        self.field_name = "Obstruction Feature Type Code"
        self.note = 'Three-digit Feature Type Code, or "UND" for Unknown Feature Type'
        self.default_value = "UND"

    def validateValue(self):
        # Assert that the length of the value is 3
        obj_len = len(str(self.value))
        assert (
            obj_len == 1 or obj_len == 3
        ), "The value must be 1 or 3 characters in length."

        # If the value is not None then assert that it is in the code_list list
        if self.value is not None:
            assert (
                self.value in self.code_list
            ), f"The value {self.value} must be in the Obstruction Feature Type Code list {self.code_list}."
