# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/client.ipynb (unless otherwise specified).

__all__ = ['Client', 'getCardToken', 'chargeCard', 'verifyOtp']

# Cell
from nicHelper.wrappers import add_method
from numbers import Number
import requests, sentry_sdk

# Cell
from .helper import Keys
from .exceptions import GBPResponseError

# Cell

class Client:
  '''
    main client for interface with global prime pay
  '''
  def __init__(self, pub, secret, endpoint = 'https://api.globalprimepay.com'):
    '''
      input:
        pub: str:: publiceKey from web
        secret: str:: secretKey from web
      docs (https://doc.gbprimepay.com)
    '''
    self.key = Keys(pub,secret)
    self.endpoint = endpoint


# Cell
@add_method(Client)
def getCardToken(self, cardNumber, expirationMonth, expirationYear, securityCode, name, **kwargs):

  body = {
    "rememberCard": True,
    "card": {
      "number": cardNumber,
      "expirationMonth": expirationMonth,
      "expirationYear": expirationYear,
      "securityCode": securityCode,
      "name": name
    }
    ,**kwargs
  }

  headersCharge = {
    'Authorization': self.key.pubPL,
    'Content-Type': 'application/json',
  }
  baseURL = self.endpoint
  url = f'{baseURL}/v2/tokens'
  r:requests.Response = requests.post(url,headers = headersCharge, json = body)
  jsonResponse = r.json()
  if r.status_code >= 400:
    sentry_sdk.add_breadcrumb(category = 'gbPrimePay', data = {'input':body, 'response':jsonResponse} , level = 'critical')
    raise GBPResponseError(f'error response, input payload is {body}, response from gb is {jsonResponse}')
  return jsonResponse


# Cell
@add_method(Client)
def chargeCard(self, token:str,
               amount:Number,
               referenceNo:str,
               customerName:str,
               customerEmail:str,
               detail:str,
               responseUrl:str = "https://responseUrl",
               backgroundUrl:str =  "https://backgroundUrl",
               otp:str = "Y",
               **kwargs)->dict:
  body = {
    "amount": amount,
    "referenceNo": referenceNo,
    "detail": detail,
    "customerName": customerName,
    "customerEmail": customerEmail,
    "card": {
      "token": token
    },
    "otp": otp,
    "responseUrl": responseUrl,
    "backgroundUrl": backgroundUrl,
    **kwargs
  }

  url = f'{self.endpoint}/v2/tokens/charge'
  headers = {
    'Authorization': self.key.secPL,
    'Content-Type': 'application/json',
  }
  r = requests.post(url, json=body, headers = headers)
  jsonResponse = r.json()
  # handle error
  if r.status_code >= 400:
    sentry_sdk.add_breadcrumb(category = 'gbPrimePay', data = {'input':body, 'response':jsonResponse} , level = 'critical')
    raise GBPResponseError(f'error response, input payload is {body}, response from gb is {jsonResponse}')
  return jsonResponse



# Cell
@add_method(Client)
def verifyOtp(self, gbpReferenceNo):
  params = {
      'publicKey': self.key.pub,
      'gbpReferenceNo': gbpReferenceNo
  }
  headers3d = {
    'Content-Type': 'application/x-www-form-urlencoded',
  }
  url = self.endpoint + "/v2/tokens/3d_secured"
  r = requests.post(url, params=params, headers = headers3d)
  if r.status_code >= 400:
    sentry_sdk.add_breadcrumb(category = 'gbPrimePay', data = {'input':params, 'response':r.text} , level = 'critical')
    raise GBPResponseError(f'error response, input payload is {params}, response from gb is {r.text}')
  return r.text