/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.spark.SparkEnv$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfoManager;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerWrapper$;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BlockManagerWrapper$ {
    public static final BlockManagerWrapper$ MODULE$;
    private final Function1<BlockId, Option<ByteBuffer>> getLocalBytesFn;
    private final Function3<BlockId, ChunkedByteBuffer, StorageLevel, BoxedUnit> putBytesFn;
    private final Function1<BlockId, BoxedUnit> unlockFn;

    static {
        new BlockManagerWrapper$();
    }

    public void putBytes(BlockId blockId, ByteBuffer bytes, StorageLevel level) {
        if (bytes == null) {
            throw new IllegalArgumentException("Bytes is null");
        }
        this.putBytesFn().apply((Object)blockId, (Object)new ChunkedByteBuffer(bytes), (Object)level);
    }

    public Option<BlockResult> getLocal(BlockId blockId) {
        return SparkEnv$.MODULE$.get().blockManager().getLocalValues(blockId);
    }

    public void putSingle(BlockId blockId, Object value2, StorageLevel level, boolean tellMaster) {
        SparkEnv$.MODULE$.get().blockManager().putSingle(blockId, value2, level, tellMaster, ClassTag$.MODULE$.Any());
    }

    public boolean putSingle$default$4() {
        return true;
    }

    public void removeBlock(BlockId blockId) {
        BlockManager qual$1 = SparkEnv$.MODULE$.get().blockManager();
        BlockId x$3 = blockId;
        boolean x$4 = qual$1.removeBlock$default$2();
        qual$1.removeBlock(x$3, x$4);
    }

    public Option<ByteBuffer> getLocalBytes(BlockId blockId) {
        return (Option)this.getLocalBytesFn().apply((Object)blockId);
    }

    public Option<ByteBuffer> getLocalOrRemoteBytes(BlockId blockId) {
        Option maybeLocalBytes = (Option)this.getLocalBytesFn().apply((Object)blockId);
        return maybeLocalBytes.isDefined() ? maybeLocalBytes : SparkEnv$.MODULE$.get().blockManager().getRemoteBytes(blockId).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ByteBuffer apply(ChunkedByteBuffer x$1) {
                return x$1.toByteBuffer();
            }
        });
    }

    public void unlock(BlockId blockId) {
        BlockInfoManager blockInfoManager = SparkEnv$.MODULE$.get().blockManager().blockInfoManager();
        if (blockInfoManager.get(blockId).isDefined()) {
            this.unlockFn().apply((Object)blockId);
        }
    }

    private Function1<BlockId, Option<ByteBuffer>> getLocalBytesFn() {
        return this.getLocalBytesFn;
    }

    private Function3<BlockId, ChunkedByteBuffer, StorageLevel, BoxedUnit> putBytesFn() {
        return this.putBytesFn;
    }

    private Function1<BlockId, BoxedUnit> unlockFn() {
        return this.unlockFn;
    }

    private final Function1 liftedTree1$1(Method getLocalBytesMethod$1) {
        Object object;
        try {
            Class<?> blockDataClass = Class.forName("org.apache.spark.storage.BlockData");
            Method toByteBufferMethod = blockDataClass.getMethod("toByteBuffer", new Class[0]);
            object = new Serializable(getLocalBytesMethod$1, toByteBufferMethod){
                public static final long serialVersionUID = 0L;
                private final Method getLocalBytesMethod$1;
                public final Method toByteBufferMethod$1;

                public final Option<ByteBuffer> apply(BlockId blockId) {
                    return ((Option)this.getLocalBytesMethod$1.invoke((Object)SparkEnv$.MODULE$.get().blockManager(), blockId)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.liftedTree1.1.1 $outer;

                        public final ByteBuffer apply(Object blockData) {
                            return (ByteBuffer)this.$outer.toByteBufferMethod$1.invoke(blockData, new Object[0]);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.getLocalBytesMethod$1 = getLocalBytesMethod$1;
                    this.toByteBufferMethod$1 = toByteBufferMethod$1;
                }
            };
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = new Serializable(getLocalBytesMethod$1){
                public static final long serialVersionUID = 0L;
                private final Method getLocalBytesMethod$1;

                public final Option<ByteBuffer> apply(BlockId blockId) {
                    return ((Option)this.getLocalBytesMethod$1.invoke((Object)SparkEnv$.MODULE$.get().blockManager(), blockId)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ByteBuffer apply(ChunkedByteBuffer x$2) {
                            return x$2.toByteBuffer();
                        }
                    });
                }
                {
                    this.getLocalBytesMethod$1 = getLocalBytesMethod$1;
                }
            };
        }
        return object;
    }

    private final Method liftedTree2$1(Class bmClass$1) {
        Method method;
        try {
            method = bmClass$1.getMethod("putBytes", BlockId.class, ChunkedByteBuffer.class, StorageLevel.class, Boolean.TYPE, ClassTag.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = bmClass$1.getMethod("putBytes", BlockId.class, ChunkedByteBuffer.class, StorageLevel.class, Boolean.TYPE, Boolean.TYPE, ClassTag.class);
        }
        return method;
    }

    private final Method liftedTree3$1(Class bimClass$1) {
        Method method;
        try {
            method = bimClass$1.getMethod("unlock", BlockId.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = bimClass$1.getMethod("unlock", BlockId.class, Option.class);
        }
        return method;
    }

    private BlockManagerWrapper$() {
        Object object;
        Object object2;
        MODULE$ = this;
        Class<BlockManager> bmClass = BlockManager.class;
        Method getLocalBytesMethod = bmClass.getMethod("getLocalBytes", BlockId.class);
        this.getLocalBytesFn = this.liftedTree1$1(getLocalBytesMethod);
        Class<BlockManager> bmClass2 = BlockManager.class;
        Method putBytesMethod = this.liftedTree2$1(bmClass2);
        int n = putBytesMethod.getParameterTypes().length;
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 6: {
                object2 = new Serializable(putBytesMethod){
                    public static final long serialVersionUID = 0L;
                    private final Method putBytesMethod$1;

                    public final void apply(BlockId blockId, ChunkedByteBuffer bytes, StorageLevel level) {
                        this.putBytesMethod$1.invoke((Object)SparkEnv$.MODULE$.get().blockManager(), blockId, bytes, level, Boolean.TRUE, Boolean.FALSE, null);
                    }
                    {
                        this.putBytesMethod$1 = putBytesMethod$1;
                    }
                };
                break;
            }
            case 5: {
                object2 = new Serializable(putBytesMethod){
                    public static final long serialVersionUID = 0L;
                    private final Method putBytesMethod$1;

                    public final void apply(BlockId blockId, ChunkedByteBuffer bytes, StorageLevel level) {
                        this.putBytesMethod$1.invoke((Object)SparkEnv$.MODULE$.get().blockManager(), blockId, bytes, level, Boolean.TRUE, null);
                    }
                    {
                        this.putBytesMethod$1 = putBytesMethod$1;
                    }
                };
            }
        }
        this.putBytesFn = object2;
        Class<BlockInfoManager> bimClass = BlockInfoManager.class;
        Method unlockMethod = this.liftedTree3$1(bimClass);
        int n2 = unlockMethod.getParameterTypes().length;
        switch (n2) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
            case 2: {
                object = new Serializable(unlockMethod){
                    public static final long serialVersionUID = 0L;
                    private final Method unlockMethod$1;

                    public final void apply(BlockId blockId) {
                        this.unlockMethod$1.invoke((Object)SparkEnv$.MODULE$.get().blockManager().blockInfoManager(), blockId, None$.MODULE$);
                    }
                    {
                        this.unlockMethod$1 = unlockMethod$1;
                    }
                };
                break;
            }
            case 1: {
                object = new Serializable(unlockMethod){
                    public static final long serialVersionUID = 0L;
                    private final Method unlockMethod$1;

                    public final void apply(BlockId blockId) {
                        this.unlockMethod$1.invoke((Object)SparkEnv$.MODULE$.get().blockManager().blockInfoManager(), blockId);
                    }
                    {
                        this.unlockMethod$1 = unlockMethod$1;
                    }
                };
            }
        }
        this.unlockFn = object;
    }
}

