/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;

public class Version {
    private static final String DEV_VERSION_STRING = "0.0.0-SNAPSHOT";
    public static final Version DEV_VERSION = Version.parse("0.0.0-SNAPSHOT");
    private static final String SNAPSHOT_MARKER = "-SNAPSHOT";
    private final int major;
    private final int minor;
    private final int revision;
    private final boolean snapshot;

    public Version(int major, int minor, int revision, boolean snapshot) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.snapshot = snapshot;
    }

    public Version(int major, int minor, int revision) {
        this(major, minor, revision, false);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        return Integer.toString(this.getMajor()) + "." + Integer.toString(this.getMinor()) + "." + Integer.toString(this.getRevision()) + (this.isSnapshot() ? SNAPSHOT_MARKER : "");
    }

    public int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getRevision(), this.isSnapshot());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Version) {
            Version version2 = (Version)obj;
            return this.getMajor() == version2.getMajor() && this.getMinor() == version2.getMinor() && this.getRevision() == version2.getRevision() && this.isSnapshot() == version2.isSnapshot();
        }
        return false;
    }

    public static Version parse(String version2) {
        int indexFirstDot = version2.indexOf(46);
        int indexSecondDot = version2.indexOf(46, indexFirstDot + 1);
        if (indexFirstDot == -1 || indexSecondDot == -1) {
            throw new NumberFormatException("Invalid version format '" + version2 + "', expected two dots!");
        }
        int indexFirstDash = version2.indexOf(45);
        int versionEnd = indexFirstDash == -1 ? version2.length() : indexFirstDash;
        boolean snapshot = version2.endsWith(SNAPSHOT_MARKER);
        return new Version(Integer.parseInt(version2.substring(0, indexFirstDot)), Integer.parseInt(version2.substring(indexFirstDot + 1, indexSecondDot)), Integer.parseInt(version2.substring(indexSecondDot + 1, versionEnd)), snapshot);
    }

    public static Version currentVersion() {
        Properties manifest = new Properties();
        try (InputStream versionIn2 = Version.class.getResourceAsStream("opennlp.version");){
            if (versionIn2 != null) {
                manifest.load(versionIn2);
            }
        }
        catch (IOException versionIn2) {
            // empty catch block
        }
        String versionString = manifest.getProperty("OpenNLP-Version", DEV_VERSION_STRING);
        if (versionString.equals("${pom.version}")) {
            versionString = DEV_VERSION_STRING;
        }
        return Version.parse(versionString);
    }
}

