/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.Objects;
import opennlp.tools.util.StringUtil;

public class Span
implements Comparable<Span> {
    private final int start;
    private final int end;
    private final double prob;
    private final String type;

    public Span(int s2, int e, String type) {
        if (s2 < 0) {
            throw new IllegalArgumentException("start index must be zero or greater: " + s2);
        }
        if (e < 0) {
            throw new IllegalArgumentException("end index must be zero or greater: " + e);
        }
        if (s2 > e) {
            throw new IllegalArgumentException("start index must not be larger than end index: start=" + s2 + ", end=" + e);
        }
        this.start = s2;
        this.end = e;
        this.type = type;
        this.prob = 0.0;
    }

    public Span(int s2, int e, String type, double prob) {
        if (s2 < 0) {
            throw new IllegalArgumentException("start index must be zero or greater: " + s2);
        }
        if (e < 0) {
            throw new IllegalArgumentException("end index must be zero or greater: " + e);
        }
        if (s2 > e) {
            throw new IllegalArgumentException("start index must not be larger than end index: start=" + s2 + ", end=" + e);
        }
        this.start = s2;
        this.end = e;
        this.prob = prob;
        this.type = type;
    }

    public Span(int s2, int e) {
        this(s2, e, null, 0.0);
    }

    public Span(int s2, int e, double prob) {
        this(s2, e, null, prob);
    }

    public Span(Span span, int offset) {
        this(span.start + offset, span.end + offset, span.getType(), span.getProb());
    }

    public Span(Span span, double prob) {
        this(span.start, span.end, span.getType(), prob);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getType() {
        return this.type;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean contains(Span s2) {
        return this.start <= s2.getStart() && s2.getEnd() <= this.end;
    }

    public boolean contains(int index) {
        return this.start <= index && index < this.end;
    }

    public boolean startsWith(Span s2) {
        return this.getStart() == s2.getStart() && this.contains(s2);
    }

    public boolean intersects(Span s2) {
        int sstart = s2.getStart();
        return this.contains(s2) || s2.contains(this) || this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s2.getEnd();
    }

    public boolean crosses(Span s2) {
        int sstart = s2.getStart();
        return !this.contains(s2) && !s2.contains(this) && (this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s2.getEnd());
    }

    public CharSequence getCoveredText(CharSequence text) {
        if (this.getEnd() > text.length()) {
            throw new IllegalArgumentException("The span " + this.toString() + " is outside the given text which has length " + text.length() + "!");
        }
        return text.subSequence(this.getStart(), this.getEnd());
    }

    public Span trim(CharSequence text) {
        int newStartOffset = this.getStart();
        for (int i = this.getStart(); i < this.getEnd() && StringUtil.isWhitespace(text.charAt(i)); ++i) {
            ++newStartOffset;
        }
        int newEndOffset = this.getEnd();
        for (int i = this.getEnd(); i > this.getStart() && StringUtil.isWhitespace(text.charAt(i - 1)); --i) {
            --newEndOffset;
        }
        if (newStartOffset == this.getStart() && newEndOffset == this.getEnd()) {
            return this;
        }
        if (newStartOffset > newEndOffset) {
            return new Span(this.getStart(), this.getStart(), this.getType());
        }
        return new Span(newStartOffset, newEndOffset, this.getType());
    }

    @Override
    public int compareTo(Span s2) {
        if (this.getStart() < s2.getStart()) {
            return -1;
        }
        if (this.getStart() == s2.getStart()) {
            if (this.getEnd() > s2.getEnd()) {
                return -1;
            }
            if (this.getEnd() < s2.getEnd()) {
                return 1;
            }
            if (this.getType() == null && s2.getType() == null) {
                return 0;
            }
            if (this.getType() != null && s2.getType() != null) {
                return this.getType().compareTo(s2.getType());
            }
            if (this.getType() != null) {
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.getStart(), this.getEnd(), this.getType());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Span) {
            Span s2 = (Span)o;
            return this.getStart() == s2.getStart() && this.getEnd() == s2.getEnd() && Objects.equals(this.getType(), s2.getType());
        }
        return false;
    }

    public String toString() {
        StringBuilder toStringBuffer = new StringBuilder(15);
        toStringBuffer.append("[");
        toStringBuffer.append(this.getStart());
        toStringBuffer.append("..");
        toStringBuffer.append(this.getEnd());
        toStringBuffer.append(")");
        if (this.getType() != null) {
            toStringBuffer.append(" ");
            toStringBuffer.append(this.getType());
        }
        return toStringBuffer.toString();
    }

    public static String[] spansToStrings(Span[] spans, CharSequence s2) {
        String[] tokens = new String[spans.length];
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            tokens[si] = spans[si].getCoveredText(s2).toString();
        }
        return tokens;
    }

    public static String[] spansToStrings(Span[] spans, String[] tokens) {
        String[] chunks = new String[spans.length];
        StringBuilder cb = new StringBuilder();
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            cb.setLength(0);
            for (int ti = spans[si].getStart(); ti < spans[si].getEnd(); ++ti) {
                cb.append(tokens[ti]).append(" ");
            }
            chunks[si] = cb.substring(0, cb.length() - 1);
        }
        return chunks;
    }

    public double getProb() {
        return this.prob;
    }
}

