/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Sequence
implements Comparable<Sequence> {
    private double score;
    private List<String> outcomes;
    private List<Double> probs;
    private static final Double ONE = 1.0;

    public Sequence() {
        this.outcomes = new ArrayList<String>(1);
        this.probs = new ArrayList<Double>(1);
        this.score = 0.0;
    }

    public Sequence(Sequence s2) {
        this.outcomes = new ArrayList<String>(s2.outcomes.size() + 1);
        this.outcomes.addAll(s2.outcomes);
        this.probs = new ArrayList<Double>(s2.probs.size() + 1);
        this.probs.addAll(s2.probs);
        this.score = s2.score;
    }

    public Sequence(Sequence s2, String outcome, double p) {
        this.outcomes = new ArrayList<String>(s2.outcomes.size() + 1);
        this.outcomes.addAll(s2.outcomes);
        this.outcomes.add(outcome);
        this.probs = new ArrayList<Double>(s2.probs.size() + 1);
        this.probs.addAll(s2.probs);
        this.probs.add(p);
        this.score = s2.score + Math.log(p);
    }

    public Sequence(List<String> outcomes) {
        this.outcomes = outcomes;
        this.probs = Collections.nCopies(outcomes.size(), ONE);
    }

    @Override
    public int compareTo(Sequence s2) {
        return Double.compare(s2.score, this.score);
    }

    public int hashCode() {
        return Objects.hash(this.outcomes, this.probs, this.score);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Sequence) {
            Sequence other = (Sequence)obj;
            double epsilon = 1.0E-7;
            return Objects.equals(this.outcomes, other.outcomes) && Objects.equals(this.probs, other.probs) && Math.abs(this.score - other.score) < epsilon;
        }
        return false;
    }

    public void add(String outcome, double p) {
        this.outcomes.add(outcome);
        this.probs.add(p);
        this.score += Math.log(p);
    }

    public List<String> getOutcomes() {
        return this.outcomes;
    }

    public double[] getProbs() {
        double[] ps = new double[this.probs.size()];
        this.getProbs(ps);
        return ps;
    }

    public double getScore() {
        return this.score;
    }

    public void getProbs(double[] ps) {
        int pl = this.probs.size();
        for (int pi = 0; pi < pl; ++pi) {
            ps[pi] = this.probs.get(pi);
        }
    }

    public String toString() {
        return this.score + " " + this.outcomes;
    }
}

