/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import opennlp.tools.tokenize.AbstractTokenizer;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

public class SimpleTokenizer
extends AbstractTokenizer {
    public static final SimpleTokenizer INSTANCE = new SimpleTokenizer();

    @Deprecated
    public SimpleTokenizer() {
    }

    @Override
    public Span[] tokenizePos(String s2) {
        CharacterEnum charType;
        CharacterEnum state = charType = CharacterEnum.WHITESPACE;
        ArrayList<Span> tokens = new ArrayList<Span>();
        int sl = s2.length();
        int start2 = -1;
        char pc = '\u0000';
        for (int ci = 0; ci < sl; ++ci) {
            char c = s2.charAt(ci);
            charType = StringUtil.isWhitespace(c) ? CharacterEnum.WHITESPACE : (Character.isLetter(c) ? CharacterEnum.ALPHABETIC : (Character.isDigit(c) ? CharacterEnum.NUMERIC : CharacterEnum.OTHER));
            if (state == CharacterEnum.WHITESPACE) {
                if (charType != CharacterEnum.WHITESPACE) {
                    start2 = ci;
                }
            } else if (charType != state || charType == CharacterEnum.OTHER && c != pc) {
                tokens.add(new Span(start2, ci));
                start2 = ci;
            }
            state = charType;
            pc = c;
        }
        if (charType != CharacterEnum.WHITESPACE) {
            tokens.add(new Span(start2, sl));
        }
        return tokens.toArray(new Span[tokens.size()]);
    }

    static class CharacterEnum {
        static final CharacterEnum WHITESPACE = new CharacterEnum("whitespace");
        static final CharacterEnum ALPHABETIC = new CharacterEnum("alphabetic");
        static final CharacterEnum NUMERIC = new CharacterEnum("numeric");
        static final CharacterEnum OTHER = new CharacterEnum("other");
        private String name;

        private CharacterEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

