/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.ArrayList;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.util.Span;

public class NewlineSentenceDetector
implements SentenceDetector {
    @Override
    public String[] sentDetect(String s2) {
        return Span.spansToStrings(this.sentPosDetect(s2), s2);
    }

    @Override
    public Span[] sentPosDetect(String s2) {
        Span span;
        ArrayList<Span> sentences = new ArrayList<Span>();
        int start2 = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c != '\n' && c != '\r' || i - start2 <= 0) continue;
            Span span2 = new Span(start2, i).trim(s2);
            if (span2.length() > 0) {
                sentences.add(span2);
            }
            start2 = i + 1;
        }
        if (s2.length() - start2 > 0 && (span = new Span(start2, s2.length()).trim(s2)).length() > 0) {
            sentences.add(span);
        }
        return sentences.toArray(new Span[sentences.size()]);
    }
}

