/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InvalidFormatException;

public class POSSample {
    private List<String> sentence;
    private List<String> tags;
    private final String[][] additionalContext;

    public POSSample(String[] sentence, String[] tags) {
        this(sentence, tags, (String[][])null);
    }

    public POSSample(List<String> sentence, List<String> tags) {
        this(sentence, tags, (String[][])null);
    }

    public POSSample(List<String> sentence, List<String> tags, String[][] additionalContext) {
        String[][] ac;
        this.sentence = Collections.unmodifiableList(sentence);
        this.tags = Collections.unmodifiableList(tags);
        this.checkArguments();
        if (additionalContext != null) {
            ac = new String[additionalContext.length][];
            for (int i = 0; i < additionalContext.length; ++i) {
                ac[i] = new String[additionalContext[i].length];
                System.arraycopy(additionalContext[i], 0, ac[i], 0, additionalContext[i].length);
            }
        } else {
            ac = null;
        }
        this.additionalContext = ac;
    }

    public POSSample(String[] sentence, String[] tags, String[][] additionalContext) {
        this(Arrays.asList(sentence), Arrays.asList(tags), additionalContext);
    }

    private void checkArguments() {
        if (this.sentence.size() != this.tags.size()) {
            throw new IllegalArgumentException("There must be exactly one tag for each token. tokens: " + this.sentence.size() + ", tags: " + this.tags.size());
        }
        if (this.sentence.contains(null)) {
            throw new IllegalArgumentException("null elements are not allowed in sentence tokens!");
        }
        if (this.tags.contains(null)) {
            throw new IllegalArgumentException("null elements are not allowed in tags!");
        }
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String[][] getAddictionalContext() {
        return this.additionalContext;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < this.getSentence().length; ++i) {
            result2.append(this.getSentence()[i]);
            result2.append('_');
            result2.append(this.getTags()[i]);
            result2.append(' ');
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - 1);
        }
        return result2.toString();
    }

    public static POSSample parse(String sentenceString) throws InvalidFormatException {
        String[] tokenTags = WhitespaceTokenizer.INSTANCE.tokenize(sentenceString);
        String[] sentence = new String[tokenTags.length];
        String[] tags = new String[tokenTags.length];
        for (int i = 0; i < tokenTags.length; ++i) {
            int split2 = tokenTags[i].lastIndexOf("_");
            if (split2 == -1) {
                throw new InvalidFormatException("Cannot find \"_\" inside token '" + tokenTags[i] + "'!");
            }
            sentence[i] = tokenTags[i].substring(0, split2);
            tags[i] = tokenTags[i].substring(split2 + 1);
        }
        return new POSSample(sentence, tags);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.getSentence()), Arrays.hashCode(this.getTags()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof POSSample) {
            POSSample a = (POSSample)obj;
            return Arrays.equals(this.getSentence(), a.getSentence()) && Arrays.equals(this.getTags(), a.getTags());
        }
        return this == obj;
    }
}

