/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.treeinsert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import opennlp.tools.parser.AbstractContextGenerator;
import opennlp.tools.parser.Cons;
import opennlp.tools.parser.Parse;

public class AttachContextGenerator
extends AbstractContextGenerator {
    public AttachContextGenerator(Set<String> punctSet) {
        this.punctSet = punctSet;
    }

    public String[] getContext(Object o) {
        Object[] parts = (Object[])o;
        return this.getContext((Parse[])parts[0], (Integer)parts[1], (List)parts[2], (Integer)parts[3]);
    }

    private boolean containsPunct(Collection<Parse> puncts, String punct) {
        if (puncts != null) {
            for (Parse p : puncts) {
                if (!p.getType().equals(punct)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getContext(Parse[] constituents, int index, List<Parse> rightFrontier, int rfi) {
        ArrayList<String> features2 = new ArrayList<String>(100);
        Parse fn = rightFrontier.get(rfi);
        Parse fp = null;
        if (rfi + 1 < rightFrontier.size()) {
            fp = rightFrontier.get(rfi + 1);
        }
        Parse p_1 = null;
        if (rightFrontier.size() > 0) {
            p_1 = rightFrontier.get(0);
        }
        Parse p0 = constituents[index];
        Parse p1 = null;
        if (index + 1 < constituents.length) {
            p1 = constituents[index + 1];
        }
        Collection<Parse> punct_1fs = fn.getPreviousPunctuationSet();
        Collection<Parse> punct_1s = p0.getPreviousPunctuationSet();
        Collection<Parse> punct1s = p0.getNextPunctuationSet();
        String consfp = this.cons(fp, -3);
        String consf = this.cons(fn, -2);
        String consp_1 = this.cons(p_1, -1);
        String consp0 = this.cons(p0, 0);
        String consp1 = this.cons(p1, 1);
        String consbofp = this.consbo(fp, -3);
        String consbof = this.consbo(fn, -2);
        String consbop_1 = this.consbo(p_1, -1);
        String consbop0 = this.consbo(p0, 0);
        String consbop1 = this.consbo(p1, 1);
        Cons cfp = new Cons(consfp, consbofp, -3, true);
        Cons cf = new Cons(consf, consbof, -2, true);
        Cons c_1 = new Cons(consp_1, consbop_1, -1, true);
        Cons c0 = new Cons(consp0, consbop0, 0, true);
        Cons c1 = new Cons(consp1, consbop1, 1, true);
        features2.add("default");
        features2.add(consfp);
        features2.add(consbofp);
        features2.add(consf);
        features2.add(consbof);
        features2.add(consp_1);
        features2.add(consbop_1);
        features2.add(consp0);
        features2.add(consbop0);
        features2.add(consp1);
        features2.add(consbop1);
        String prod2 = this.production(fn, false);
        features2.add("pn=" + prod2);
        features2.add("pd=" + prod2 + "," + p0.getType());
        features2.add("ps=" + fn.getType() + "->" + fn.getType() + "," + p0.getType());
        if (punct_1s != null) {
            StringBuilder punctBuf = new StringBuilder(5);
            for (Parse punct : punct_1s) {
                punctBuf.append(punct.getType()).append(",");
            }
        }
        this.cons2(features2, cfp, c0, punct_1s, true);
        this.cons2(features2, cf, c0, punct_1s, true);
        this.cons2(features2, c_1, c0, punct_1s, true);
        this.cons2(features2, c0, c1, punct1s, true);
        this.cons3(features2, cf, c_1, c0, null, punct_1s, true, true, true);
        this.cons3(features2, cf, c0, c1, punct_1s, punct1s, true, true, true);
        this.cons3(features2, cfp, cf, c0, null, punct_1s, true, true, true);
        int headDistance = p0.getHeadIndex() - fn.getHeadIndex();
        features2.add("hd=" + headDistance);
        features2.add("nd=" + rfi);
        features2.add("nd=" + p0.getType() + "." + rfi);
        features2.add("hd=" + p0.getType() + "." + headDistance);
        if (this.containsPunct(punct_1s, "''") && this.containsPunct(punct_1fs, "``")) {
            features2.add("quotematch");
        }
        return features2.toArray(new String[features2.size()]);
    }
}

