/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.chunking;

import java.util.List;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.Event;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.AbstractParserEventStream;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.chunking.BuildContextGenerator;
import opennlp.tools.parser.chunking.CheckContextGenerator;
import opennlp.tools.util.ObjectStream;

public class ParserEventStream
extends AbstractParserEventStream {
    protected BuildContextGenerator bcg;
    protected CheckContextGenerator kcg;

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype, Dictionary dict) {
        super(d, rules, etype, dict);
    }

    @Override
    protected void init() {
        if (this.etype == ParserEventTypeEnum.BUILD) {
            this.bcg = new BuildContextGenerator(this.dict);
        } else if (this.etype == ParserEventTypeEnum.CHECK) {
            this.kcg = new CheckContextGenerator();
        }
    }

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype) {
        this(d, rules, etype, null);
    }

    protected boolean firstChild(Parse child, Parse parent) {
        return AbstractBottomUpParser.collapsePunctuation(parent.getChildren(), this.punctSet)[0] == child;
    }

    public static Parse[] reduceChunks(Parse[] chunks, int ci, Parse parent) {
        Parse[] reducedChunks;
        int reduceStart;
        String type = parent.getType();
        int reduceEnd = ci;
        for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
        }
        ++reduceStart;
        if (!type.equals("TOP")) {
            reducedChunks = new Parse[chunks.length - (reduceEnd - reduceStart + 1) + 1];
            System.arraycopy(chunks, 0, reducedChunks, 0, reduceStart);
            reducedChunks[reduceStart] = parent;
            parent.setPrevPunctuation(chunks[reduceStart].getPreviousPunctuationSet());
            parent.setNextPunctuation(chunks[reduceEnd].getNextPunctuationSet());
            int ri = reduceStart + 1;
            for (int rci = reduceEnd + 1; rci < chunks.length; ++rci) {
                reducedChunks[ri] = chunks[rci];
                ++ri;
            }
            ci = reduceStart - 1;
        } else {
            reducedChunks = new Parse[]{};
        }
        return reducedChunks;
    }

    @Override
    protected void addParseEvents(List<Event> parseEvents, Parse[] chunks) {
        for (int ci = 0; ci < chunks.length; ++ci) {
            int start2;
            Parse c = chunks[ci];
            Parse parent = c.getParent();
            if (parent == null) continue;
            String type = parent.getType();
            String outcome = this.firstChild(c, parent) ? "S-" + type : "C-" + type;
            c.setLabel(outcome);
            if (this.etype == ParserEventTypeEnum.BUILD) {
                parseEvents.add(new Event(outcome, this.bcg.getContext(chunks, ci)));
            }
            for (start2 = ci - 1; start2 >= 0 && chunks[start2].getParent() == parent; --start2) {
            }
            if (this.lastChild(c, parent)) {
                int reduceStart;
                if (this.etype == ParserEventTypeEnum.CHECK) {
                    parseEvents.add(new Event("c", this.kcg.getContext(chunks, type, start2 + 1, ci)));
                }
                for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
                }
                chunks = ParserEventStream.reduceChunks(chunks, ci, parent);
                ci = ++reduceStart - 1;
                continue;
            }
            if (this.etype != ParserEventTypeEnum.CHECK) continue;
            parseEvents.add(new Event("i", this.kcg.getContext(chunks, type, start2 + 1, ci)));
        }
    }
}

