/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class ChunkSampleStream
extends FilterObjectStream<Parse, ChunkSample> {
    public ChunkSampleStream(ObjectStream<Parse> in) {
        super(in);
    }

    private static void getInitialChunks(Parse p, List<Parse> ichunks) {
        if (p.isPosTag()) {
            ichunks.add(p);
        } else {
            int ci;
            Parse[] kids = p.getChildren();
            boolean allKidsAreTags = true;
            int cl = kids.length;
            for (ci = 0; ci < cl; ++ci) {
                if (kids[ci].isPosTag()) continue;
                allKidsAreTags = false;
                break;
            }
            if (allKidsAreTags) {
                ichunks.add(p);
            } else {
                cl = kids.length;
                for (ci = 0; ci < cl; ++ci) {
                    ChunkSampleStream.getInitialChunks(kids[ci], ichunks);
                }
            }
        }
    }

    public static Parse[] getInitialChunks(Parse p) {
        ArrayList<Parse> chunks = new ArrayList<Parse>();
        ChunkSampleStream.getInitialChunks(p, chunks);
        return chunks.toArray(new Parse[chunks.size()]);
    }

    @Override
    public ChunkSample read() throws IOException {
        Parse parse2 = (Parse)this.samples.read();
        if (parse2 != null) {
            Parse[] chunks = ChunkSampleStream.getInitialChunks(parse2);
            ArrayList<String> toks = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<String> preds = new ArrayList<String>();
            for (Parse c : chunks) {
                if (c.isPosTag()) {
                    toks.add(c.getCoveredText());
                    tags.add(c.getType());
                    preds.add("O");
                    continue;
                }
                boolean start2 = true;
                String ctype = c.getType();
                for (Parse tok : c.getChildren()) {
                    toks.add(tok.getCoveredText());
                    tags.add(tok.getType());
                    if (start2) {
                        preds.add("S-" + ctype);
                        start2 = false;
                        continue;
                    }
                    preds.add("C-" + ctype);
                }
            }
            return new ChunkSample(toks.toArray(new String[toks.size()]), tags.toArray(new String[tags.size()]), preds.toArray(new String[preds.size()]));
        }
        return null;
    }
}

