/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.ArrayList;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.util.Cache;
import opennlp.tools.util.TokenTag;

public class ChunkContextGenerator
implements ChunkerContextGenerator {
    private static final String EOS = "eos";
    private Cache<String, String[]> contextsCache;
    private Object wordsKey;

    public ChunkContextGenerator() {
        this(0);
    }

    public ChunkContextGenerator(int cacheSize) {
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    @Deprecated
    public String[] getContext(Object o) {
        Object[] data2 = (Object[])o;
        return this.getContext((int)((Integer)data2[0]), (String[])data2[1], (String[])data2[2], (String[])data2[3]);
    }

    @Deprecated
    public String[] getContext(int i, String[] words, String[] prevDecisions, Object[] ac) {
        return this.getContext(i, words, (String[])ac[0], prevDecisions);
    }

    @Override
    public String[] getContext(int i, String[] words, String[] tags, String[] preds) {
        String w2;
        String t2;
        String w1;
        String t1;
        String w_1;
        String p_1;
        String t_1;
        String w_2;
        String p_2;
        String t_2;
        ArrayList<String> features2 = new ArrayList<String>(19);
        int x_2 = i - 2;
        int x_1 = i - 1;
        int x2 = i + 2;
        int x1 = i + 1;
        if (x_2 >= 0) {
            t_2 = tags[x_2];
            p_2 = preds[x_2];
            w_2 = words[x_2];
        } else {
            t_2 = EOS;
            p_2 = EOS;
            w_2 = EOS;
        }
        if (x_1 >= 0) {
            t_1 = tags[x_1];
            p_1 = preds[x_1];
            w_1 = words[x_1];
        } else {
            t_1 = EOS;
            p_1 = EOS;
            w_1 = EOS;
        }
        String t0 = tags[i];
        String w0 = words[i];
        if (x1 < tags.length) {
            t1 = tags[x1];
            w1 = words[x1];
        } else {
            t1 = EOS;
            w1 = EOS;
        }
        if (x2 < tags.length) {
            t2 = tags[x2];
            w2 = words[x2];
        } else {
            t2 = EOS;
            w2 = EOS;
        }
        String cacheKey = i + t_2 + t1 + t0 + t1 + t2 + p_2 + p_1;
        if (this.contextsCache != null) {
            if (this.wordsKey == words) {
                String[] contexts = (String[])this.contextsCache.get(cacheKey);
                if (contexts != null) {
                    return contexts;
                }
            } else {
                this.contextsCache.clear();
                this.wordsKey = words;
            }
        }
        String ct_2 = this.chunkandpostag(-2, w_2, t_2, p_2);
        String ctbo_2 = this.chunkandpostagbo(-2, t_2, p_2);
        String ct_1 = this.chunkandpostag(-1, w_1, t_1, p_1);
        String ctbo_1 = this.chunkandpostagbo(-1, t_1, p_1);
        String ct0 = this.chunkandpostag(0, w0, t0, null);
        String ctbo0 = this.chunkandpostagbo(0, t0, null);
        String ct1 = this.chunkandpostag(1, w1, t1, null);
        String ctbo1 = this.chunkandpostagbo(1, t1, null);
        String ct2 = this.chunkandpostag(2, w2, t2, null);
        String ctbo2 = this.chunkandpostagbo(2, t2, null);
        features2.add("default");
        features2.add(ct_2);
        features2.add(ctbo_2);
        features2.add(ct_1);
        features2.add(ctbo_1);
        features2.add(ct0);
        features2.add(ctbo0);
        features2.add(ct1);
        features2.add(ctbo1);
        features2.add(ct2);
        features2.add(ctbo2);
        features2.add(ct_1 + "," + ct0);
        features2.add(ctbo_1 + "," + ct0);
        features2.add(ct_1 + "," + ctbo0);
        features2.add(ctbo_1 + "," + ctbo0);
        features2.add(ct0 + "," + ct1);
        features2.add(ctbo0 + "," + ct1);
        features2.add(ct0 + "," + ctbo1);
        features2.add(ctbo0 + "," + ctbo1);
        String[] contexts = features2.toArray(new String[features2.size()]);
        if (this.contextsCache != null) {
            this.contextsCache.put(cacheKey, contexts);
        }
        return contexts;
    }

    private String chunkandpostag(int i, String tok, String tag, String chunk) {
        StringBuilder feat = new StringBuilder(20);
        feat.append(i).append("=").append(tok).append("|").append(tag);
        if (i < 0) {
            feat.append("|").append(chunk);
        }
        return feat.toString();
    }

    private String chunkandpostagbo(int i, String tag, String chunk) {
        StringBuilder feat = new StringBuilder(20);
        feat.append(i).append("*=").append(tag);
        if (i < 0) {
            feat.append("|").append(chunk);
        }
        return feat.toString();
    }

    public String[] getContext(int index, TokenTag[] sequence2, String[] priorDecisions, Object[] additionalContext) {
        String[] token = TokenTag.extractTokens(sequence2);
        String[] tags = TokenTag.extractTags(sequence2);
        return this.getContext(index, token, tags, priorDecisions);
    }
}

