/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionaryEntryPersistor;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;
import opennlp.tools.util.StringUtil;

public class NGramModel
implements Iterable<StringList> {
    protected static final String COUNT = "count";
    private Map<StringList, Integer> mNGrams = new HashMap<StringList, Integer>();

    public NGramModel() {
    }

    public NGramModel(InputStream in) throws IOException {
        DictionaryEntryPersistor.create(in, entry -> {
            int count2;
            String countValueString = null;
            try {
                countValueString = entry.getAttributes().getValue(COUNT);
                if (countValueString == null) {
                    throw new InvalidFormatException("The count attribute must be set!");
                }
                count2 = Integer.parseInt(countValueString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("The count attribute '" + countValueString + "' must be a number!", e);
            }
            this.add(entry.getTokens());
            this.setCount(entry.getTokens(), count2);
        });
    }

    public int getCount(StringList ngram) {
        Integer count2 = this.mNGrams.get(ngram);
        if (count2 == null) {
            return 0;
        }
        return count2;
    }

    public void setCount(StringList ngram, int count2) {
        Integer oldCount = this.mNGrams.put(ngram, count2);
        if (oldCount == null) {
            this.mNGrams.remove(ngram);
            throw new NoSuchElementException();
        }
    }

    public void add(StringList ngram) {
        if (this.contains(ngram)) {
            this.setCount(ngram, this.getCount(ngram) + 1);
        } else {
            this.mNGrams.put(ngram, 1);
        }
    }

    public void add(StringList ngram, int minLength, int maxLength) {
        if (minLength < 1 || maxLength < 1) {
            throw new IllegalArgumentException("minLength and maxLength param must be at least 1. minLength=" + minLength + ", maxLength= " + maxLength);
        }
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength param must not be larger than maxLength param. minLength=" + minLength + ", maxLength= " + maxLength);
        }
        for (int lengthIndex = minLength; lengthIndex < maxLength + 1; ++lengthIndex) {
            int textIndex = 0;
            while (textIndex + lengthIndex - 1 < ngram.size()) {
                String[] grams = new String[lengthIndex];
                for (int i = textIndex; i < textIndex + lengthIndex; ++i) {
                    grams[i - textIndex] = ngram.getToken(i);
                }
                this.add(new StringList(grams));
                ++textIndex;
            }
        }
    }

    public void add(CharSequence chars, int minLength, int maxLength) {
        for (int lengthIndex = minLength; lengthIndex < maxLength + 1; ++lengthIndex) {
            int textIndex = 0;
            while (textIndex + lengthIndex - 1 < chars.length()) {
                String gram = StringUtil.toLowerCase(chars.subSequence(textIndex, textIndex + lengthIndex));
                this.add(new StringList(new String[]{gram}));
                ++textIndex;
            }
        }
    }

    public void remove(StringList tokens) {
        this.mNGrams.remove(tokens);
    }

    public boolean contains(StringList tokens) {
        return this.mNGrams.containsKey(tokens);
    }

    public int size() {
        return this.mNGrams.size();
    }

    @Override
    public Iterator<StringList> iterator() {
        return this.mNGrams.keySet().iterator();
    }

    public int numberOfGrams() {
        int counter = 0;
        for (StringList ngram : this) {
            counter += this.getCount(ngram);
        }
        return counter;
    }

    public void cutoff(int cutoffUnder, int cutoffOver) {
        if (cutoffUnder > 0 || cutoffOver < Integer.MAX_VALUE) {
            Iterator<StringList> it = this.iterator();
            while (it.hasNext()) {
                StringList ngram = it.next();
                int count2 = this.getCount(ngram);
                if (count2 >= cutoffUnder && count2 <= cutoffOver) continue;
                it.remove();
            }
        }
    }

    public Dictionary toDictionary() {
        return this.toDictionary(false);
    }

    public Dictionary toDictionary(boolean caseSensitive) {
        Dictionary dict = new Dictionary(caseSensitive);
        for (StringList stringList : this) {
            dict.put(stringList);
        }
        return dict;
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entryIterator = new Iterator<Entry>(){
            private Iterator<StringList> mDictionaryIterator;
            {
                this.mDictionaryIterator = NGramModel.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mDictionaryIterator.hasNext();
            }

            @Override
            public Entry next() {
                StringList tokens = this.mDictionaryIterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue(NGramModel.COUNT, Integer.toString(NGramModel.this.getCount(tokens)));
                return new Entry(tokens, attributes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionaryEntryPersistor.serialize(out, entryIterator, false);
    }

    public boolean equals(Object obj) {
        boolean result2;
        if (obj == this) {
            result2 = true;
        } else if (obj instanceof NGramModel) {
            NGramModel model = (NGramModel)obj;
            result2 = this.mNGrams.equals(model.mNGrams);
        } else {
            result2 = false;
        }
        return result2;
    }

    public String toString() {
        return "Size: " + this.size();
    }

    public int hashCode() {
        return this.mNGrams.hashCode();
    }
}

