/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import opennlp.tools.namefind.BilouNameFinderSequenceValidator;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;

public class BilouCodec
implements SequenceCodec<String> {
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String LAST = "last";
    public static final String UNIT = "unit";
    public static final String OTHER = "other";

    @Override
    public Span[] decode(List<String> c) {
        int start2 = -1;
        int end = -1;
        ArrayList<Span> spans = new ArrayList<Span>(c.size());
        for (int li = 0; li < c.size(); ++li) {
            String chunkTag = c.get(li);
            if (chunkTag.endsWith(START)) {
                start2 = li;
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(CONTINUE)) {
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(LAST)) {
                if (start2 == -1) continue;
                spans.add(new Span(start2, end + 1, BioCodec.extractNameType(c.get(li - 1))));
                start2 = -1;
                end = -1;
                continue;
            }
            if (!chunkTag.endsWith(UNIT)) continue;
            spans.add(new Span(li, li + 1, BioCodec.extractNameType(c.get(li))));
        }
        return spans.toArray(new Span[spans.size()]);
    }

    public String[] encode(Span[] names, int length) {
        Object[] outcomes = new String[length];
        Arrays.fill(outcomes, OTHER);
        for (Span name : names) {
            if (name.length() > 1) {
                outcomes[name.getStart()] = name.getType() == null ? "default-start" : name.getType() + "-" + START;
                for (int i = name.getStart() + 1; i < name.getEnd() - 1; ++i) {
                    outcomes[i] = name.getType() == null ? "default-cont" : name.getType() + "-" + CONTINUE;
                }
                if (name.getType() == null) {
                    outcomes[name.getEnd() - 1] = "default-last";
                    continue;
                }
                outcomes[name.getEnd() - 1] = name.getType() + "-" + LAST;
                continue;
            }
            outcomes[name.getEnd() - 1] = name.getType() == null ? "default-unit" : name.getType() + "-" + UNIT;
        }
        return outcomes;
    }

    @Override
    public SequenceValidator<String> createSequenceValidator() {
        return new BilouNameFinderSequenceValidator();
    }

    @Override
    public boolean areOutcomesCompatible(String[] outcomes) {
        HashSet<String> start2 = new HashSet<String>();
        HashSet<String> cont = new HashSet<String>();
        HashSet<String> last = new HashSet<String>();
        HashSet<String> unit = new HashSet<String>();
        for (int i = 0; i < outcomes.length; ++i) {
            String outcome = outcomes[i];
            if (outcome.endsWith(START)) {
                start2.add(outcome.substring(0, outcome.length() - START.length()));
                continue;
            }
            if (outcome.endsWith(CONTINUE)) {
                cont.add(outcome.substring(0, outcome.length() - CONTINUE.length()));
                continue;
            }
            if (outcome.endsWith(LAST)) {
                last.add(outcome.substring(0, outcome.length() - LAST.length()));
                continue;
            }
            if (outcome.endsWith(UNIT)) {
                unit.add(outcome.substring(0, outcome.length() - UNIT.length()));
                continue;
            }
            if (outcome.equals(OTHER)) continue;
            return false;
        }
        if (start2.size() == 0 && unit.size() == 0) {
            return false;
        }
        for (String startPrefix : start2) {
            if (last.contains(startPrefix)) continue;
            return false;
        }
        for (String contPrefix : cont) {
            if (start2.contains(contPrefix) || last.contains(contPrefix)) continue;
            return false;
        }
        for (String lastPrefix : last) {
            if (start2.contains(lastPrefix)) continue;
            return false;
        }
        return true;
    }
}

