/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.perceptron;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelWriter;
import opennlp.tools.ml.model.ComparablePredicate;
import opennlp.tools.ml.model.Context;

public abstract class PerceptronModelWriter
extends AbstractModelWriter {
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected String[] PRED_LABELS;
    private int numOutcomes;

    public PerceptronModelWriter(AbstractModel model) {
        Object[] data2 = model.getDataStructures();
        this.numOutcomes = model.getNumOutcomes();
        this.PARAMS = (Context[])data2[0];
        Map pmap = (Map)data2[1];
        this.OUTCOME_LABELS = (String[])data2[2];
        this.PARAMS = new Context[pmap.size()];
        this.PRED_LABELS = new String[pmap.size()];
        int i = 0;
        for (Map.Entry pred : pmap.entrySet()) {
            this.PRED_LABELS[i] = (String)pred.getKey();
            this.PARAMS[i] = (Context)pred.getValue();
            ++i;
        }
    }

    protected ComparablePredicate[] sortValues() {
        ComparablePredicate[] tmpPreds = new ComparablePredicate[this.PARAMS.length];
        int[] tmpOutcomes = new int[this.numOutcomes];
        double[] tmpParams = new double[this.numOutcomes];
        int numPreds = 0;
        for (int pid = 0; pid < this.PARAMS.length; ++pid) {
            int numParams = 0;
            double[] predParams = this.PARAMS[pid].getParameters();
            int[] outcomePattern = this.PARAMS[pid].getOutcomes();
            for (int pi = 0; pi < predParams.length; ++pi) {
                if (predParams[pi] == 0.0) continue;
                tmpOutcomes[numParams] = outcomePattern[pi];
                tmpParams[numParams] = predParams[pi];
                ++numParams;
            }
            int[] activeOutcomes = new int[numParams];
            double[] activeParams = new double[numParams];
            for (int pi = 0; pi < numParams; ++pi) {
                activeOutcomes[pi] = tmpOutcomes[pi];
                activeParams[pi] = tmpParams[pi];
            }
            if (numParams == 0) continue;
            tmpPreds[numPreds] = new ComparablePredicate(this.PRED_LABELS[pid], activeOutcomes, activeParams);
            ++numPreds;
        }
        System.err.println("Compressed " + this.PARAMS.length + " parameters to " + numPreds);
        Object[] sortPreds = new ComparablePredicate[numPreds];
        System.arraycopy(tmpPreds, 0, sortPreds, 0, numPreds);
        Arrays.sort(sortPreds);
        return sortPreds;
    }

    protected List<List<ComparablePredicate>> computeOutcomePatterns(ComparablePredicate[] sorted) {
        ComparablePredicate cp = sorted[0];
        ArrayList<List<ComparablePredicate>> outcomePatterns = new ArrayList<List<ComparablePredicate>>();
        ArrayList<ComparablePredicate> newGroup = new ArrayList<ComparablePredicate>();
        for (ComparablePredicate predicate : sorted) {
            if (cp.compareTo(predicate) == 0) {
                newGroup.add(predicate);
                continue;
            }
            cp = predicate;
            outcomePatterns.add(newGroup);
            newGroup = new ArrayList();
            newGroup.add(predicate);
        }
        outcomePatterns.add(newGroup);
        System.err.println(outcomePatterns.size() + " outcome patterns");
        return outcomePatterns;
    }

    @Override
    public void persist() throws IOException {
        this.writeUTF("Perceptron");
        this.writeInt(this.OUTCOME_LABELS.length);
        for (String label : this.OUTCOME_LABELS) {
            this.writeUTF(label);
        }
        ComparablePredicate[] sorted = this.sortValues();
        List<List<ComparablePredicate>> compressed = this.computeOutcomePatterns(sorted);
        this.writeInt(compressed.size());
        for (List<ComparablePredicate> a : compressed) {
            this.writeUTF(a.size() + a.get(0).toString());
        }
        this.writeInt(sorted.length);
        for (ComparablePredicate s2 : sorted) {
            this.writeUTF(s2.name);
        }
        for (int i = 0; i < sorted.length; ++i) {
            for (int j = 0; j < sorted[i].params.length; ++j) {
                this.writeDouble(sorted[i].params[j]);
            }
        }
        this.close();
    }
}

