/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.perceptron;

import java.util.Arrays;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;

public class PerceptronModel
extends AbstractModel {
    public PerceptronModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        super(params, predLabels, outcomeNames);
        this.modelType = AbstractModel.ModelType.Perceptron;
    }

    @Override
    public double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, float[] values2) {
        return this.eval(context, values2, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, double[] probs) {
        return this.eval(context, null, probs);
    }

    public double[] eval(String[] context, float[] values2, double[] outsums) {
        Context[] scontexts = new Context[context.length];
        Arrays.fill(outsums, 0.0);
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = (Context)this.pmap.get(context[i]);
        }
        return PerceptronModel.eval(scontexts, values2, outsums, this.evalParams, true);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return PerceptronModel.eval(context, null, prior, model, true);
    }

    static double[] eval(int[] context, float[] values2, double[] prior, EvalParameters model, boolean normalize) {
        Context[] scontexts = new Context[context.length];
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = model.getParams()[context[i]];
        }
        return PerceptronModel.eval(scontexts, values2, prior, model, normalize);
    }

    static double[] eval(Context[] context, float[] values2, double[] prior, EvalParameters model, boolean normalize) {
        int oid;
        Context[] params = model.getParams();
        double value2 = 1.0;
        for (int ci = 0; ci < context.length; ++ci) {
            if (context[ci] == null) continue;
            Context predParams = context[ci];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            if (values2 != null) {
                value2 = values2[ci];
            }
            for (int ai = 0; ai < activeOutcomes.length; ++ai) {
                int n = oid = activeOutcomes[ai];
                prior[n] = prior[n] + activeParameters[ai] * value2;
            }
        }
        if (normalize) {
            int oid2;
            int numOutcomes = model.getNumOutcomes();
            double maxPrior = 1.0;
            for (oid = 0; oid < numOutcomes; ++oid) {
                if (!(maxPrior < Math.abs(prior[oid]))) continue;
                maxPrior = Math.abs(prior[oid]);
            }
            double normal = 0.0;
            for (oid2 = 0; oid2 < numOutcomes; ++oid2) {
                prior[oid2] = Math.exp(prior[oid2] / maxPrior);
                normal += prior[oid2];
            }
            oid2 = 0;
            while (oid2 < numOutcomes) {
                int n = oid2++;
                prior[n] = prior[n] / normal;
            }
        }
        return prior;
    }
}

