/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;

public class OnePassDataIndexer
extends AbstractDataIndexer {
    @Override
    public void index(ObjectStream<Event> eventStream) throws IOException {
        int cutoff = this.trainingParameters.getIntParameter("Cutoff", 5);
        boolean sort2 = this.trainingParameters.getBooleanParameter("sort", true);
        long start2 = System.currentTimeMillis();
        this.display("Indexing events with OnePass using cutoff of " + cutoff + "\n\n");
        this.display("\tComputing event counts...  ");
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        List<Event> events = this.computeEventCounts(eventStream, predicateIndex, cutoff);
        this.display("done. " + events.size() + " events\n");
        this.display("\tIndexing...  ");
        List<ComparableEvent> eventsToCompare = this.index(ObjectStreamUtils.createObjectStream(events), predicateIndex);
        this.display("done.\n");
        this.display("Sorting and merging events... ");
        this.sortAndMerge(eventsToCompare, sort2);
        this.display(String.format("Done indexing in %.2f s.\n", (double)(System.currentTimeMillis() - start2) / 1000.0));
    }

    private List<Event> computeEventCounts(ObjectStream<Event> eventStream, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        Event ev;
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        LinkedList<Event> events = new LinkedList<Event>();
        while ((ev = eventStream.read()) != null) {
            events.add(ev);
            OnePassDataIndexer.update(ev.getContext(), counter);
        }
        String[] predicateSet = (String[])counter.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= cutoff).map(Map.Entry::getKey).sorted().toArray(String[]::new);
        this.predCounts = new int[predicateSet.length];
        for (int i = 0; i < predicateSet.length; ++i) {
            this.predCounts[i] = (Integer)counter.get(predicateSet[i]);
            predicatesInOut.put(predicateSet[i], i);
        }
        return events;
    }
}

