/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.ext.ExtensionLoader;

public class DataIndexerFactory {
    public static DataIndexer getDataIndexer(TrainingParameters parameters2, Map<String, String> reportMap) {
        DataIndexer indexer;
        String indexerParam = parameters2.getStringParameter("DataIndexer", "TwoPass");
        if (reportMap == null) {
            reportMap = new HashMap<String, String>();
        }
        switch (indexerParam) {
            case "OnePass": {
                indexer = new OnePassDataIndexer();
                break;
            }
            case "TwoPass": {
                indexer = new TwoPassDataIndexer();
                break;
            }
            case "OnePassRealValue": {
                indexer = new OnePassRealValueDataIndexer();
                break;
            }
            default: {
                indexer = ExtensionLoader.instantiateExtension(DataIndexer.class, indexerParam);
            }
        }
        indexer.init(parameters2, reportMap);
        return indexer;
    }
}

