/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.quasinewton;

import java.util.List;

public class ArrayMath {
    public static double innerProduct(double[] vecA, double[] vecB) {
        if (vecA == null || vecB == null || vecA.length != vecB.length) {
            return Double.NaN;
        }
        double product = 0.0;
        for (int i = 0; i < vecA.length; ++i) {
            product += vecA[i] * vecB[i];
        }
        return product;
    }

    public static double l1norm(double[] v) {
        double norm2 = 0.0;
        for (int i = 0; i < v.length; ++i) {
            norm2 += Math.abs(v[i]);
        }
        return norm2;
    }

    public static double l2norm(double[] v) {
        return Math.sqrt(ArrayMath.innerProduct(v, v));
    }

    public static double invL2norm(double[] v) {
        return 1.0 / ArrayMath.l2norm(v);
    }

    public static double logSumOfExps(double[] x) {
        double max2 = ArrayMath.max(x);
        double sum2 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == Double.NEGATIVE_INFINITY) continue;
            sum2 += Math.exp(x[i] - max2);
        }
        return max2 + Math.log(sum2);
    }

    public static double max(double[] x) {
        int maxIdx = ArrayMath.maxIdx(x);
        return x[maxIdx];
    }

    public static int maxIdx(double[] x) {
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException("Vector x is null or empty");
        }
        int maxIdx = 0;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[maxIdx] < x[i])) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    public static double[] toDoubleArray(List<Double> list2) {
        double[] arr = new double[list2.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list2.get(i);
        }
        return arr;
    }

    public static int[] toIntArray(List<Integer> list2) {
        int[] arr = new int[list2.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list2.get(i);
        }
        return arr;
    }
}

