/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;
import opennlp.tools.ml.model.Prior;
import opennlp.tools.ml.model.UniformPrior;

public final class GISModel
extends AbstractModel {
    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        this(params, predLabels, outcomeNames, new UniformPrior());
    }

    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames, Prior prior) {
        super(params, predLabels, outcomeNames);
        this.prior = prior;
        prior.setLabels(outcomeNames, predLabels);
        this.modelType = AbstractModel.ModelType.Maxent;
    }

    @Override
    public final double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public final double[] eval(String[] context, float[] values2) {
        return this.eval(context, values2, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public final double[] eval(String[] context, double[] outsums) {
        return this.eval(context, null, outsums);
    }

    public final double[] eval(String[] context, float[] values2, double[] outsums) {
        Context[] scontexts = new Context[context.length];
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = (Context)this.pmap.get(context[i]);
        }
        this.prior.logPrior(outsums, scontexts, values2);
        return GISModel.eval(scontexts, values2, outsums, this.evalParams);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return GISModel.eval(context, null, prior, model);
    }

    static double[] eval(int[] context, float[] values2, double[] prior, EvalParameters model) {
        Context[] scontexts = new Context[context.length];
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = model.getParams()[context[i]];
        }
        return GISModel.eval(scontexts, values2, prior, model);
    }

    static double[] eval(Context[] context, float[] values2, double[] prior, EvalParameters model) {
        int oid;
        int[] numfeats = new int[model.getNumOutcomes()];
        double value2 = 1.0;
        for (int ci = 0; ci < context.length; ++ci) {
            if (context[ci] == null) continue;
            Context predParams = context[ci];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            if (values2 != null) {
                value2 = values2[ci];
            }
            for (int ai = 0; ai < activeOutcomes.length; ++ai) {
                int oid2;
                int n = oid2 = activeOutcomes[ai];
                numfeats[n] = numfeats[n] + 1;
                int n2 = oid2;
                prior[n2] = prior[n2] + activeParameters[ai] * value2;
            }
        }
        double normal = 0.0;
        for (oid = 0; oid < model.getNumOutcomes(); ++oid) {
            prior[oid] = Math.exp(prior[oid]);
            normal += prior[oid];
        }
        oid = 0;
        while (oid < model.getNumOutcomes()) {
            int n = oid++;
            prior[n] = prior[n] / normal;
        }
        return prior;
    }
}

