/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorContextGenerator;
import opennlp.tools.langdetect.LanguageDetectorEventStream;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public class LanguageDetectorME
implements LanguageDetector {
    private LanguageDetectorModel model;
    private LanguageDetectorContextGenerator mContextGenerator;

    public LanguageDetectorME(LanguageDetectorModel model) {
        this.model = model;
        this.mContextGenerator = model.getFactory().getContextGenerator();
    }

    @Override
    public Language[] predictLanguages(CharSequence content) {
        double[] eval2 = this.model.getMaxentModel().eval(this.mContextGenerator.getContext(content.toString()));
        Language[] arr = new Language[eval2.length];
        for (int i = 0; i < eval2.length; ++i) {
            arr[i] = new Language(this.model.getMaxentModel().getOutcome(i), eval2[i]);
        }
        Arrays.sort(arr, (o1, o2) -> Double.compare(o2.getConfidence(), o1.getConfidence()));
        return arr;
    }

    @Override
    public Language predictLanguage(CharSequence content) {
        return this.predictLanguages(content)[0];
    }

    @Override
    public String[] getSupportedLanguages() {
        int numberLanguages = this.model.getMaxentModel().getNumOutcomes();
        String[] languages = new String[numberLanguages];
        for (int i = 0; i < numberLanguages; ++i) {
            languages[i] = this.model.getMaxentModel().getOutcome(i);
        }
        return languages;
    }

    public static LanguageDetectorModel train(ObjectStream<LanguageSample> samples, TrainingParameters mlParams, LanguageDetectorFactory factory) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        mlParams.putIfAbsent("DataIndexer", "OnePass");
        EventTrainer trainer = TrainerFactory.getEventTrainer(mlParams, manifestInfoEntries);
        MaxentModel model = trainer.train(new LanguageDetectorEventStream(samples, factory.getContextGenerator()));
        return new LanguageDetectorModel(model, manifestInfoEntries, factory);
    }
}

