/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.letsmt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.SAXParser;
import opennlp.tools.util.XmlUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LetsmtDocument {
    private List<LetsmtSentence> sentences = new ArrayList<LetsmtSentence>();

    private LetsmtDocument(List<LetsmtSentence> sentences) {
        this.sentences = sentences;
    }

    public List<LetsmtSentence> getSentences() {
        return Collections.unmodifiableList(this.sentences);
    }

    static LetsmtDocument parse(InputStream letsmtXmlIn) throws IOException {
        SAXParser saxParser = XmlUtil.createSaxParser();
        try {
            XMLReader xmlReader = saxParser.getXMLReader();
            LetsmtDocumentHandler docHandler = new LetsmtDocumentHandler();
            xmlReader.setContentHandler(docHandler);
            xmlReader.parse(new InputSource(letsmtXmlIn));
            return new LetsmtDocument(docHandler.sentences);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse letsmt xml!", e);
        }
    }

    static LetsmtDocument parse(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            LetsmtDocument letsmtDocument = LetsmtDocument.parse(in);
            return letsmtDocument;
        }
    }

    public static class LetsmtDocumentHandler
    extends DefaultHandler {
        private List<LetsmtSentence> sentences = new ArrayList<LetsmtSentence>();
        private StringBuilder chars = new StringBuilder();
        private List<String> tokens = new ArrayList<String>();

        @Override
        public void characters(char[] ch, int start2, int length) throws SAXException {
            this.chars.append(ch, start2, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            switch (qName) {
                case "w": {
                    this.tokens.add(this.chars.toString().trim());
                    this.chars.setLength(0);
                    break;
                }
                case "s": {
                    LetsmtSentence sentence = new LetsmtSentence();
                    if (this.tokens.size() > 0) {
                        LetsmtSentence.access$002(sentence, this.tokens.toArray(new String[this.tokens.size()]));
                        this.tokens = new ArrayList<String>();
                    } else {
                        sentence.nonTokenizedText = this.chars.toString().trim();
                    }
                    this.sentences.add(sentence);
                    this.chars.setLength(0);
                }
            }
        }
    }

    public static class LetsmtSentence {
        private String nonTokenizedText;
        private String[] tokens;

        public String getNonTokenizedText() {
            return this.nonTokenizedText;
        }

        public String[] getTokens() {
            if (this.tokens != null) {
                return Arrays.copyOf(this.tokens, this.tokens.length);
            }
            return null;
        }

        static /* synthetic */ String[] access$002(LetsmtSentence x0, String[] x1) {
            x0.tokens = x1;
            return x1;
        }
    }
}

