/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import opennlp.tools.formats.conllu.ConlluSentence;
import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.formats.conllu.ConlluWordLine;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

public class ConlluStream
implements ObjectStream<ConlluSentence> {
    private final ObjectStream<String> sentenceStream;

    public ConlluStream(InputStreamFactory in) throws IOException {
        this.sentenceStream = new ParagraphStream(new PlainTextByLineStream(in, StandardCharsets.UTF_8));
    }

    @Override
    public ConlluSentence read() throws IOException {
        String sentence = this.sentenceStream.read();
        if (sentence != null) {
            String line;
            List<ConlluWordLine> wordLines = new ArrayList<ConlluWordLine>();
            BufferedReader reader = new BufferedReader(new StringReader(sentence));
            String sentenceId = null;
            String text = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#")) {
                    String commentLine = line.trim().substring(1);
                    int separator = commentLine.indexOf(61);
                    if (separator == -1) continue;
                    String firstPart = commentLine.substring(0, separator).trim();
                    String secondPart = commentLine.substring(separator + 1, commentLine.length()).trim();
                    if (secondPart.isEmpty()) continue;
                    switch (firstPart) {
                        case "sent_id": {
                            sentenceId = secondPart;
                            break;
                        }
                        case "text": {
                            text = secondPart;
                        }
                    }
                    continue;
                }
                wordLines.add(new ConlluWordLine(line));
            }
            wordLines = this.postProcessContractions(wordLines);
            return new ConlluSentence(wordLines, sentenceId, text);
        }
        return null;
    }

    private List<ConlluWordLine> postProcessContractions(List<ConlluWordLine> lines) {
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        HashMap contractions = new HashMap();
        ArrayList<Object> linesToDelete = new ArrayList<Object>();
        for (int i = 0; i < lines.size(); ++i) {
            ConlluWordLine line = lines.get(i);
            index.put(line.getId(), i);
            if (!line.getId().contains("-")) continue;
            ArrayList<Object> expandedContractions = new ArrayList<Object>();
            String[] ids = line.getId().split("-");
            int start2 = Integer.parseInt(ids[0]);
            int end = Integer.parseInt(ids[1]);
            for (int j = start2; j <= end; ++j) {
                String js = Integer.toString(j);
                expandedContractions.add(js);
                linesToDelete.add(js);
            }
            contractions.put(line.getId(), expandedContractions);
        }
        for (Map.Entry entry : contractions.entrySet()) {
            String contractionId = (String)entry.getKey();
            List expandedContractions = (List)entry.getValue();
            int contractionIndex = (Integer)index.get(contractionId);
            ConlluWordLine contraction = lines.get(contractionIndex);
            ArrayList<ConlluWordLine> expandedParts = new ArrayList<ConlluWordLine>();
            for (String id : expandedContractions) {
                expandedParts.add(lines.get((Integer)index.get(id)));
            }
            ConlluWordLine merged = this.mergeAnnotation(contraction, expandedParts);
            lines.set(contractionIndex, merged);
        }
        for (int i = linesToDelete.size() - 1; i >= 0; --i) {
            lines.remove((Integer)index.get(linesToDelete.get(i)));
        }
        return lines;
    }

    private ConlluWordLine mergeAnnotation(ConlluWordLine contraction, List<ConlluWordLine> expandedParts) {
        String id = contraction.getId();
        String form = contraction.getForm();
        String lemma = expandedParts.stream().filter(p -> !"_".equals(p.getLemma())).map(p -> p.getLemma()).collect(Collectors.joining("+"));
        String uPosTag = expandedParts.stream().filter(p -> !"_".equals(p.getPosTag(ConlluTagset.U))).map(p -> p.getPosTag(ConlluTagset.U)).collect(Collectors.joining("+"));
        String xPosTag = expandedParts.stream().filter(p -> !"_".equals(p.getPosTag(ConlluTagset.X))).map(p -> p.getPosTag(ConlluTagset.X)).collect(Collectors.joining("+"));
        String feats = expandedParts.stream().filter(p -> !"_".equals(p.getFeats())).map(p -> p.getFeats()).collect(Collectors.joining("+"));
        String head = contraction.getHead();
        String deprel = contraction.getDeprel();
        String deps = contraction.getDeps();
        String misc = contraction.getMisc();
        return new ConlluWordLine(id, form, lemma, uPosTag, xPosTag, feats, head, deprel, deps, misc);
    }

    @Override
    public void close() throws IOException {
        this.sentenceStream.close();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.sentenceStream.reset();
    }
}

