/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTypedParamTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.parser.ParserModelLoader;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.util.ObjectStream;

abstract class ModelUpdaterTool
extends AbstractTypedParamTool<Parse, ModelUpdaterParams> {
    protected ModelUpdaterTool() {
        super(Parse.class, ModelUpdaterParams.class);
    }

    protected abstract ParserModel trainAndUpdate(ParserModel var1, ObjectStream<Parse> var2, ModelUpdaterParams var3) throws IOException;

    @Override
    public final void run(String format2, String[] args) {
        ParserModel updatedParserModel;
        ModelUpdaterParams params = this.validateAndParseParams(ArgumentParser.filter(args, ModelUpdaterParams.class), ModelUpdaterParams.class);
        File modelFile = params.getModel();
        ParserModel originalParserModel = (ParserModel)new ParserModelLoader().load(modelFile);
        ObjectStreamFactory factory = this.getStreamFactory(format2);
        String[] fargs = ArgumentParser.filter(args, factory.getParameters());
        this.validateFactoryArgs(factory, fargs);
        ObjectStream<Parse> sampleStream = factory.create(fargs);
        try {
            updatedParserModel = this.trainAndUpdate(originalParserModel, sampleStream, params);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("parser", modelFile, updatedParserModel);
    }

    static interface ModelUpdaterParams
    extends TrainingToolParams {
    }
}

