/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.NameSampleCountersStream;
import opennlp.tools.cmdline.namefind.TrainingParams;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.namefind.BilouCodec;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.ModelUtil;

public final class TokenNameFinderTrainerTool
extends AbstractTrainerTool<NameSample, TrainerToolParams> {
    public TokenNameFinderTrainerTool() {
        super(NameSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable name finder";
    }

    static byte[] openFeatureGeneratorBytes(String featureGenDescriptorFile) {
        if (featureGenDescriptorFile != null) {
            return TokenNameFinderTrainerTool.openFeatureGeneratorBytes(new File(featureGenDescriptorFile));
        }
        return null;
    }

    public static byte[] openFeatureGeneratorBytes(File featureGenDescriptorFile) {
        byte[] featureGeneratorBytes = null;
        if (featureGenDescriptorFile != null) {
            try (FileInputStream bytesIn = CmdLineUtil.openInFile(featureGenDescriptorFile);){
                featureGeneratorBytes = ModelUtil.read(bytesIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
            }
        }
        return featureGeneratorBytes;
    }

    public static Map<String, Object> loadResources(File resourcePath, File featureGenDescriptor) throws IOException {
        HashMap<String, Object> resources = new HashMap<String, Object>();
        if (resourcePath != null) {
            HashMap artifactSerializers = new HashMap();
            if (featureGenDescriptor != null) {
                try (FileInputStream xmlDescriptorIn = CmdLineUtil.openInFile(featureGenDescriptor);){
                    artifactSerializers.putAll(GeneratorFactory.extractArtifactSerializerMappings(xmlDescriptorIn));
                }
            }
            for (Map.Entry serializerMapping : artifactSerializers.entrySet()) {
                String resourceName = (String)serializerMapping.getKey();
                FileInputStream resourceIn = CmdLineUtil.openInFile(new File(resourcePath, resourceName));
                Throwable throwable = null;
                try {
                    resources.put(resourceName, ((ArtifactSerializer)serializerMapping.getValue()).create(resourceIn));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resourceIn == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)resourceIn).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)resourceIn).close();
                }
            }
        }
        return resources;
    }

    @Override
    public void run(String format2, String[] args) {
        TokenNameFinderModel model;
        TokenNameFinderFactory nameFinderFactory;
        String sequenceCodecImplName;
        Map<String, Object> resources;
        super.run(format2, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), true);
        if (this.mlParams == null) {
            this.mlParams = new TrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((TrainerToolParams)this.params).getFeaturegen());
        try {
            resources = TokenNameFinderTrainerTool.loadResources(((TrainerToolParams)this.params).getResources(), ((TrainerToolParams)this.params).getFeaturegen());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, e.getMessage(), e);
        }
        CmdLineUtil.checkOutputFile("name finder model", modelOutFile);
        if (((TrainerToolParams)this.params).getNameTypes() != null) {
            String[] nameTypes = ((TrainerToolParams)this.params).getNameTypes().split(",");
            this.sampleStream = new NameSampleTypeFilter(nameTypes, (ObjectStream<NameSample>)this.sampleStream);
        }
        if ("BIO".equals(sequenceCodecImplName = ((TrainerToolParams)this.params).getSequenceCodec())) {
            sequenceCodecImplName = BioCodec.class.getName();
        } else if ("BILOU".equals(sequenceCodecImplName)) {
            sequenceCodecImplName = BilouCodec.class.getName();
        }
        SequenceCodec<String> sequenceCodec = TokenNameFinderFactory.instantiateSequenceCodec(sequenceCodecImplName);
        try {
            nameFinderFactory = TokenNameFinderFactory.create(((TrainerToolParams)this.params).getFactory(), featureGeneratorBytes, resources, sequenceCodec);
        }
        catch (InvalidFormatException e) {
            throw new TerminateToolException(-1, e.getMessage(), e);
        }
        NameSampleCountersStream counters = new NameSampleCountersStream(this.sampleStream);
        this.sampleStream = counters;
        try {
            model = NameFinderME.train(((TrainerToolParams)this.params).getLang(), ((TrainerToolParams)this.params).getType(), this.sampleStream, this.mlParams, nameFinderFactory);
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.out.println();
        counters.printSummary();
        System.out.println();
        CmdLineUtil.writeModel("name finder", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

