/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.langdetect;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.langdetect.TrainingParams;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.model.ModelUtil;

public class LanguageDetectorTrainerTool
extends AbstractTrainerTool<LanguageSample, TrainerToolParams> {
    public LanguageDetectorTrainerTool() {
        super(LanguageSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable language detector";
    }

    @Override
    public void run(String format2, String[] args) {
        LanguageDetectorModel model;
        super.run(format2, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("language detector model", modelOutFile);
        try {
            LanguageDetectorFactory factory = LanguageDetectorFactory.create(((TrainerToolParams)this.params).getFactory());
            model = LanguageDetectorME.train(this.sampleStream, this.mlParams, factory);
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("language detector", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams {
        @ArgumentParser.ParameterDescription(valueName="modelFile", description="output model file.")
        public File getModel();

        @Override
        @ArgumentParser.ParameterDescription(valueName="paramsFile", description="training parameters file.")
        @ArgumentParser.OptionalParameter
        public String getParams();
    }
}

