/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.util.Map;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;

public abstract class TypedCmdLineTool<T>
extends CmdLineTool {
    protected final Class<T> type;

    protected TypedCmdLineTool(Class<T> sampleType) {
        this.type = sampleType;
    }

    protected ObjectStreamFactory<T> getStreamFactory(String format2) {
        ObjectStreamFactory<T> factory = StreamFactoryRegistry.getFactory(this.type, format2);
        if (null != factory) {
            return factory;
        }
        throw new TerminateToolException(1, "Format " + format2 + " is not found.\n" + this.getHelp());
    }

    protected <A> void validateAllArgs(String[] args, Class<A> argProxyInterface, String format2) {
        ObjectStreamFactory<T> factory = this.getStreamFactory(format2);
        String errMessage = ArgumentParser.validateArgumentsLoudly(args, argProxyInterface, factory.getParameters());
        if (null != errMessage) {
            throw new TerminateToolException(1, errMessage + "\n" + this.getHelp(format2));
        }
    }

    protected void validateFactoryArgs(ObjectStreamFactory<T> factory, String[] args) {
        String errMessage = ArgumentParser.validateArgumentsLoudly(args, factory.getParameters());
        if (null != errMessage) {
            throw new TerminateToolException(1, "Format parameters are invalid: " + errMessage + "\nUsage: " + ArgumentParser.createUsage(factory.getParameters()));
        }
    }

    @Override
    protected String getBasicHelp(Class<?> ... argProxyInterfaces) {
        Map<String, ObjectStreamFactory<T>> factories = StreamFactoryRegistry.getFactories(this.type);
        String formatsHelp = " ";
        if (1 < factories.size()) {
            StringBuilder formats = new StringBuilder();
            for (String format2 : factories.keySet()) {
                if ("opennlp".equals(format2)) continue;
                formats.append(".").append(format2).append("|");
            }
            formatsHelp = "[" + formats.substring(0, formats.length() - 1) + "] ";
        }
        return "Usage: opennlp " + this.getName() + formatsHelp + ArgumentParser.createUsage(argProxyInterfaces);
    }

    @Override
    public String getHelp() {
        return this.getHelp("");
    }

    public abstract void run(String var1, String[] var2);

    public abstract String getHelp(String var1);
}

