/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.TypedCmdLineTool;

public abstract class AbstractTypedParamTool<T, P>
extends TypedCmdLineTool<T> {
    protected final Class<P> paramsClass;

    protected AbstractTypedParamTool(Class<T> sampleType, Class<P> paramsClass) {
        super(sampleType);
        this.paramsClass = paramsClass;
    }

    @Override
    public String getHelp(String format2) {
        if ("".equals(format2) || "opennlp".equals(format2)) {
            return this.getBasicHelp(this.paramsClass, StreamFactoryRegistry.getFactory(this.type, "opennlp").getParameters());
        }
        ObjectStreamFactory factory = StreamFactoryRegistry.getFactory(this.type, format2);
        if (null == factory) {
            throw new TerminateToolException(1, "Format " + format2 + " is not found.\n" + this.getHelp());
        }
        return "Usage: opennlp " + this.getName() + "." + format2 + " " + ArgumentParser.createUsage(this.paramsClass, factory.getParameters());
    }
}

