/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.IOException;
import java.util.Map;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.TypedCmdLineTool;
import opennlp.tools.util.ObjectStream;

public abstract class AbstractConverterTool<T>
extends TypedCmdLineTool<T> {
    protected AbstractConverterTool(Class<T> sampleType) {
        super(sampleType);
    }

    @Override
    public String getShortDescription() {
        Map factories = StreamFactoryRegistry.getFactories(this.type);
        StringBuilder help = new StringBuilder();
        if (2 == factories.keySet().size()) {
            for (String format2 : factories.keySet()) {
                if ("opennlp".equals(format2)) continue;
                help.append(format2);
            }
            return "converts " + help.toString() + " data format to native OpenNLP format";
        }
        if (2 < factories.keySet().size()) {
            for (String format3 : factories.keySet()) {
                if ("opennlp".equals(format3)) continue;
                help.append(format3).append(",");
            }
            return "converts foreign data formats (" + help.substring(0, help.length() - 1) + ") to native OpenNLP format";
        }
        throw new AssertionError((Object)"There should be more than 1 factory registered for converter tool");
    }

    private String createHelpString(String format2, String usage2) {
        return "Usage: opennlp " + this.getName() + " " + format2 + " " + usage2;
    }

    @Override
    public String getHelp() {
        Map factories = StreamFactoryRegistry.getFactories(this.type);
        StringBuilder help = new StringBuilder("help|");
        for (String formatName : factories.keySet()) {
            if ("opennlp".equals(formatName)) continue;
            help.append(formatName).append("|");
        }
        return this.createHelpString(help.substring(0, help.length() - 1), "[help|options...]");
    }

    @Override
    public String getHelp(String format2) {
        return this.getHelp();
    }

    @Override
    public void run(String format2, String[] args) {
        if (0 == args.length) {
            System.out.println(this.getHelp());
        } else {
            String errorMessage;
            format2 = args[0];
            ObjectStreamFactory streamFactory = this.getStreamFactory(format2);
            String[] formatArgs = new String[args.length - 1];
            System.arraycopy(args, 1, formatArgs, 0, formatArgs.length);
            String helpString = this.createHelpString(format2, ArgumentParser.createUsage(streamFactory.getParameters()));
            if (0 == formatArgs.length || 1 == formatArgs.length && "help".equals(formatArgs[0])) {
                System.out.println(helpString);
                System.exit(0);
            }
            if (null != (errorMessage = ArgumentParser.validateArgumentsLoudly(formatArgs, streamFactory.getParameters()))) {
                throw new TerminateToolException(1, errorMessage + "\n" + helpString);
            }
            try (ObjectStream sampleStream = streamFactory.create(formatArgs);){
                Object sample;
                while ((sample = sampleStream.read()) != null) {
                    System.out.println(sample.toString());
                }
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while converting data : " + e.getMessage(), e);
            }
        }
    }
}

