/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;

public class ChunkerEvaluator
extends Evaluator<ChunkSample> {
    private FMeasure fmeasure = new FMeasure();
    private Chunker chunker;

    public ChunkerEvaluator(Chunker chunker, ChunkerEvaluationMonitor ... listeners) {
        super(listeners);
        this.chunker = chunker;
    }

    @Override
    protected ChunkSample processSample(ChunkSample reference) {
        String[] preds = this.chunker.chunk(reference.getSentence(), reference.getTags());
        ChunkSample result2 = new ChunkSample(reference.getSentence(), reference.getTags(), preds);
        this.fmeasure.updateScores(reference.getPhrasesAsSpanList(), result2.getPhrasesAsSpanList());
        return result2;
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

