/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibLoader.class);
    private static boolean initialized = false;
    private static final String nativeResourcePath = "/lib/";
    private static final String[] libNames = new String[]{"xgboost4j"};

    NativeLibLoader() {
    }

    static synchronized void initXGBoost() throws IOException {
        if (!initialized) {
            for (String libName : libNames) {
                try {
                    String libraryFromJar = nativeResourcePath + System.mapLibraryName(libName);
                    NativeLibLoader.loadLibraryFromJar(libraryFromJar);
                }
                catch (IOException ioe) {
                    logger.error("failed to load " + libName + " library from jar");
                    throw ioe;
                }
            }
            initialized = true;
        }
    }

    private static void loadLibraryFromJar(String path) throws IOException, IllegalArgumentException {
        String temp = NativeLibLoader.createTempFileFromResource(path);
        System.load(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String createTempFileFromResource(String path) throws IOException, IllegalArgumentException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        InputStream is = NativeLibLoader.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes2;
            while ((readBytes2 = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes2);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        return temp.getAbsolutePath();
    }
}

