/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Object2ObjectSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Object2ObjectSortedMaps() {
    }

    public static <K> Comparator<? super Map.Entry<K, ?>> entryComparator(final Comparator<K> comparator) {
        return new Comparator<Map.Entry<K, ?>>(){

            @Override
            public int compare(Map.Entry<K, ?> x, Map.Entry<K, ?> y) {
                return comparator.compare(x.getKey(), y.getKey());
            }
        };
    }

    public static <K, V> Object2ObjectSortedMap<K, V> singleton(K key, V value2) {
        return new Singleton<K, V>(key, value2);
    }

    public static <K, V> Object2ObjectSortedMap<K, V> singleton(K key, V value2, Comparator<? super K> comparator) {
        return new Singleton<K, V>(key, value2, comparator);
    }

    public static <K, V> Object2ObjectSortedMap<K, V> synchronize(Object2ObjectSortedMap<K, V> m3) {
        return new SynchronizedSortedMap<K, V>(m3);
    }

    public static <K, V> Object2ObjectSortedMap<K, V> synchronize(Object2ObjectSortedMap<K, V> m3, Object sync2) {
        return new SynchronizedSortedMap<K, V>(m3, sync2);
    }

    public static <K, V> Object2ObjectSortedMap<K, V> unmodifiable(Object2ObjectSortedMap<K, V> m3) {
        return new UnmodifiableSortedMap<K, V>(m3);
    }

    public static class UnmodifiableSortedMap<K, V>
    extends Object2ObjectMaps.UnmodifiableMap<K, V>
    implements Object2ObjectSortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Object2ObjectSortedMap<K, V> sortedMap;

        protected UnmodifiableSortedMap(Object2ObjectSortedMap<K, V> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Object2ObjectMap.Entry<K, V>> object2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.object2ObjectEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<K, V>> entrySet() {
            return this.object2ObjectEntrySet();
        }

        @Override
        public ObjectSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (ObjectSortedSet)this.keys;
        }

        @Override
        public Object2ObjectSortedMap<K, V> subMap(K from2, K to) {
            return new UnmodifiableSortedMap<K, V>(this.sortedMap.subMap(from2, to));
        }

        @Override
        public Object2ObjectSortedMap<K, V> headMap(K to) {
            return new UnmodifiableSortedMap<K, V>(this.sortedMap.headMap(to));
        }

        @Override
        public Object2ObjectSortedMap<K, V> tailMap(K from2) {
            return new UnmodifiableSortedMap<K, V>(this.sortedMap.tailMap(from2));
        }

        @Override
        public K firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sortedMap.lastKey();
        }
    }

    public static class SynchronizedSortedMap<K, V>
    extends Object2ObjectMaps.SynchronizedMap<K, V>
    implements Object2ObjectSortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Object2ObjectSortedMap<K, V> sortedMap;

        protected SynchronizedSortedMap(Object2ObjectSortedMap<K, V> m3, Object sync2) {
            super(m3, sync2);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Object2ObjectSortedMap<K, V> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Object2ObjectMap.Entry<K, V>> object2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.object2ObjectEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<K, V>> entrySet() {
            return this.object2ObjectEntrySet();
        }

        @Override
        public ObjectSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (ObjectSortedSet)this.keys;
        }

        @Override
        public Object2ObjectSortedMap<K, V> subMap(K from2, K to) {
            return new SynchronizedSortedMap<K, V>(this.sortedMap.subMap(from2, to), this.sync);
        }

        @Override
        public Object2ObjectSortedMap<K, V> headMap(K to) {
            return new SynchronizedSortedMap<K, V>(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        public Object2ObjectSortedMap<K, V> tailMap(K from2) {
            return new SynchronizedSortedMap<K, V>(this.sortedMap.tailMap(from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }
    }

    public static class Singleton<K, V>
    extends Object2ObjectMaps.Singleton<K, V>
    implements Object2ObjectSortedMap<K, V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Comparator<? super K> comparator;

        protected Singleton(K key, V value2, Comparator<? super K> comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(K key, V value2) {
            this(key, value2, null);
        }

        final int compare(K k1, K k2) {
            return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Object2ObjectMap.Entry<K, V>> object2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new Object2ObjectMaps.Singleton.SingletonEntry(), Object2ObjectSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<K, V>> entrySet() {
            return this.object2ObjectEntrySet();
        }

        @Override
        public ObjectSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSortedSets.singleton(this.key, this.comparator);
            }
            return (ObjectSortedSet)this.keys;
        }

        @Override
        public Object2ObjectSortedMap<K, V> subMap(K from2, K to) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Object2ObjectSortedMap<K, V> headMap(K to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Object2ObjectSortedMap<K, V> tailMap(K from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public K firstKey() {
            return (K)this.key;
        }

        @Override
        public K lastKey() {
            return (K)this.key;
        }
    }

    public static class EmptySortedMap<K, V>
    extends Object2ObjectMaps.EmptyMap<K, V>
    implements Object2ObjectSortedMap<K, V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Object2ObjectMap.Entry<K, V>> object2ObjectEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ObjectSortedSet<Map.Entry<K, V>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ObjectSortedSet<K> keySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public Object2ObjectSortedMap<K, V> subMap(K from2, K to) {
            return EMPTY_MAP;
        }

        @Override
        public Object2ObjectSortedMap<K, V> headMap(K to) {
            return EMPTY_MAP;
        }

        @Override
        public Object2ObjectSortedMap<K, V> tailMap(K from2) {
            return EMPTY_MAP;
        }

        @Override
        public K firstKey() {
            throw new NoSuchElementException();
        }

        @Override
        public K lastKey() {
            throw new NoSuchElementException();
        }
    }
}

