/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractReference2ByteFunction;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ByteMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractReference2ByteMap<K>
extends AbstractReference2ByteFunction<K>
implements Reference2ByteMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractReference2ByteMap() {
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Byte)ov);
    }

    @Override
    public boolean containsValue(byte v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(Object k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Byte> m3) {
        int n = m3.size();
        Iterator<Map.Entry<K, Byte>> i = m3.entrySet().iterator();
        if (m3 instanceof Reference2ByteMap) {
            while (n-- != 0) {
                Reference2ByteMap.Entry e = (Reference2ByteMap.Entry)i.next();
                this.put(e.getKey(), e.getByteValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<K, Byte> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ReferenceSet<K> keySet() {
        return new AbstractReferenceSet<K>(){

            @Override
            public boolean contains(Object k) {
                return AbstractReference2ByteMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractReference2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2ByteMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new AbstractObjectIterator<K>(){
                    final ObjectIterator<Map.Entry<K, Byte>> i;
                    {
                        this.i = AbstractReference2ByteMap.this.entrySet().iterator();
                    }

                    @Override
                    public K next() {
                        return ((Reference2ByteMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ByteCollection values() {
        return new AbstractByteCollection(){

            @Override
            public boolean contains(byte k) {
                return AbstractReference2ByteMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractReference2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2ByteMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new AbstractByteIterator(){
                    final ObjectIterator<Map.Entry<K, Byte>> i;
                    {
                        this.i = AbstractReference2ByteMap.this.entrySet().iterator();
                    }

                    @Override
                    public byte nextByte() {
                        return ((Reference2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<K, Byte>> entrySet() {
        return this.reference2ByteEntrySet();
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h2 += ((Map.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Reference2ByteMap.Entry e = (Reference2ByteMap.Entry)i.next();
            if (this == e.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e.getByteValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static class BasicEntry<K>
    implements Reference2ByteMap.Entry<K> {
        protected K key;
        protected byte value;

        public BasicEntry(K key, Byte value2) {
            this.key = key;
            this.value = value2;
        }

        public BasicEntry(K key, byte value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public Byte getValue() {
            return this.value;
        }

        @Override
        public byte getByteValue() {
            return this.value;
        }

        @Override
        public byte setValue(byte value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Byte setValue(Byte value2) {
            return this.setValue((byte)value2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == e.getKey() && this.value == (Byte)e.getValue();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

