/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class IntSortedSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private IntSortedSets() {
    }

    public static IntSortedSet singleton(int element) {
        return new Singleton(element);
    }

    public static IntSortedSet singleton(int element, IntComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static IntSortedSet singleton(Object element) {
        return new Singleton((int)((Integer)element));
    }

    public static IntSortedSet singleton(Object element, IntComparator comparator) {
        return new Singleton((Integer)element, comparator);
    }

    public static IntSortedSet synchronize(IntSortedSet s2) {
        return new SynchronizedSortedSet(s2);
    }

    public static IntSortedSet synchronize(IntSortedSet s2, Object sync2) {
        return new SynchronizedSortedSet(s2, sync2);
    }

    public static IntSortedSet unmodifiable(IntSortedSet s2) {
        return new UnmodifiableSortedSet(s2);
    }

    public static class UnmodifiableSortedSet
    extends IntSets.UnmodifiableSet
    implements IntSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final IntSortedSet sortedSet;

        protected UnmodifiableSortedSet(IntSortedSet s2) {
            super(s2);
            this.sortedSet = s2;
        }

        @Override
        public IntComparator comparator() {
            return this.sortedSet.comparator();
        }

        @Override
        public IntSortedSet subSet(int from2, int to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from2, to));
        }

        @Override
        public IntSortedSet headSet(int to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        @Override
        public IntSortedSet tailSet(int from2) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from2));
        }

        @Override
        public IntBidirectionalIterator iterator() {
            return IntIterators.unmodifiable(this.sortedSet.iterator());
        }

        @Override
        public IntBidirectionalIterator iterator(int from2) {
            return IntIterators.unmodifiable(this.sortedSet.iterator(from2));
        }

        @Override
        @Deprecated
        public IntBidirectionalIterator intIterator() {
            return this.iterator();
        }

        @Override
        public int firstInt() {
            return this.sortedSet.firstInt();
        }

        @Override
        public int lastInt() {
            return this.sortedSet.lastInt();
        }

        @Override
        public Integer first() {
            return (Integer)this.sortedSet.first();
        }

        @Override
        public Integer last() {
            return (Integer)this.sortedSet.last();
        }

        @Override
        public IntSortedSet subSet(Integer from2, Integer to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from2, to));
        }

        @Override
        public IntSortedSet headSet(Integer to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        @Override
        public IntSortedSet tailSet(Integer from2) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from2));
        }
    }

    public static class SynchronizedSortedSet
    extends IntSets.SynchronizedSet
    implements IntSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final IntSortedSet sortedSet;

        protected SynchronizedSortedSet(IntSortedSet s2, Object sync2) {
            super(s2, sync2);
            this.sortedSet = s2;
        }

        protected SynchronizedSortedSet(IntSortedSet s2) {
            super(s2);
            this.sortedSet = s2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IntComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        @Override
        public IntSortedSet subSet(int from2, int to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from2, to), this.sync);
        }

        @Override
        public IntSortedSet headSet(int to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        @Override
        public IntSortedSet tailSet(int from2) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from2), this.sync);
        }

        @Override
        public IntBidirectionalIterator iterator() {
            return this.sortedSet.iterator();
        }

        @Override
        public IntBidirectionalIterator iterator(int from2) {
            return this.sortedSet.iterator(from2);
        }

        @Override
        @Deprecated
        public IntBidirectionalIterator intIterator() {
            return this.sortedSet.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int firstInt() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastInt() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer first() {
            Object object = this.sync;
            synchronized (object) {
                return (Integer)this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer last() {
            Object object = this.sync;
            synchronized (object) {
                return (Integer)this.sortedSet.last();
            }
        }

        @Override
        public IntSortedSet subSet(Integer from2, Integer to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from2, to), this.sync);
        }

        @Override
        public IntSortedSet headSet(Integer to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        @Override
        public IntSortedSet tailSet(Integer from2) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from2), this.sync);
        }
    }

    public static class Singleton
    extends IntSets.Singleton
    implements IntSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        final IntComparator comparator;

        private Singleton(int element, IntComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(int element) {
            this(element, (IntComparator)null);
        }

        final int compare(int k1, int k2) {
            return this.comparator == null ? Integer.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        @Deprecated
        public IntBidirectionalIterator intIterator() {
            return this.iterator();
        }

        @Override
        public IntBidirectionalIterator iterator(int from2) {
            IntBidirectionalIterator i = this.iterator();
            if (this.compare(this.element, from2) <= 0) {
                i.next();
            }
            return i;
        }

        @Override
        public IntComparator comparator() {
            return this.comparator;
        }

        @Override
        public IntSortedSet subSet(int from2, int to) {
            if (this.compare(from2, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet headSet(int to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet tailSet(int from2) {
            if (this.compare(from2, this.element) <= 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public int firstInt() {
            return this.element;
        }

        @Override
        public int lastInt() {
            return this.element;
        }

        @Override
        public Integer first() {
            return this.element;
        }

        @Override
        public Integer last() {
            return this.element;
        }

        @Override
        public IntSortedSet subSet(Integer from2, Integer to) {
            return this.subSet((int)from2, (int)to);
        }

        @Override
        public IntSortedSet headSet(Integer to) {
            return this.headSet((int)to);
        }

        @Override
        public IntSortedSet tailSet(Integer from2) {
            return this.tailSet((int)from2);
        }
    }

    public static class EmptySet
    extends IntSets.EmptySet
    implements IntSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public boolean remove(int ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public IntBidirectionalIterator intIterator() {
            return this.iterator();
        }

        @Override
        public IntBidirectionalIterator iterator(int from2) {
            return IntIterators.EMPTY_ITERATOR;
        }

        @Override
        public IntSortedSet subSet(int from2, int to) {
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet headSet(int from2) {
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet tailSet(int to) {
            return EMPTY_SET;
        }

        @Override
        public int firstInt() {
            throw new NoSuchElementException();
        }

        @Override
        public int lastInt() {
            throw new NoSuchElementException();
        }

        @Override
        public IntComparator comparator() {
            return null;
        }

        @Override
        public IntSortedSet subSet(Integer from2, Integer to) {
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet headSet(Integer from2) {
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet tailSet(Integer to) {
            return EMPTY_SET;
        }

        @Override
        public Integer first() {
            throw new NoSuchElementException();
        }

        @Override
        public Integer last() {
            throw new NoSuchElementException();
        }

        @Override
        public Object clone() {
            return EMPTY_SET;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

