/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2CharFunction;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2CharMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractInt2CharMap
extends AbstractInt2CharFunction
implements Int2CharMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractInt2CharMap() {
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    @Override
    public boolean containsValue(char v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(int k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Character> m3) {
        int n = m3.size();
        Iterator<Map.Entry<? extends Integer, ? extends Character>> i = m3.entrySet().iterator();
        if (m3 instanceof Int2CharMap) {
            while (n-- != 0) {
                Int2CharMap.Entry e = (Int2CharMap.Entry)i.next();
                this.put(e.getIntKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Integer, ? extends Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntSet keySet() {
        return new AbstractIntSet(){

            @Override
            public boolean contains(int k) {
                return AbstractInt2CharMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractInt2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2CharMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    final ObjectIterator<Map.Entry<Integer, Character>> i;
                    {
                        this.i = AbstractInt2CharMap.this.entrySet().iterator();
                    }

                    @Override
                    public int nextInt() {
                        return ((Int2CharMap.Entry)this.i.next()).getIntKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k) {
                return AbstractInt2CharMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractInt2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<Integer, Character>> i;
                    {
                        this.i = AbstractInt2CharMap.this.entrySet().iterator();
                    }

                    @Override
                    public char nextChar() {
                        return ((Int2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<Integer, Character>> entrySet() {
        return this.int2CharEntrySet();
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h2 += ((Map.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Int2CharMap.Entry e = (Int2CharMap.Entry)i.next();
            s2.append(String.valueOf(e.getIntKey()));
            s2.append("=>");
            s2.append(String.valueOf(e.getCharValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static class BasicEntry
    implements Int2CharMap.Entry {
        protected int key;
        protected char value;

        public BasicEntry(Integer key, Character value2) {
            this.key = key;
            this.value = value2.charValue();
        }

        public BasicEntry(int key, char value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public Character getValue() {
            return Character.valueOf(this.value);
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Character setValue(Character value2) {
            return Character.valueOf(this.setValue(value2.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Integer)e.getKey() && this.value == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

